/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ras.couchdb.internal;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResultArchiveStoreDirectoryService;
import dev.galasa.framework.spi.IResultArchiveStoreService;
import dev.galasa.framework.spi.IRun;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.ras.ResultArchiveStoreFileStore;
import dev.galasa.framework.spi.teststructure.TestStructure;
import dev.galasa.framework.spi.utils.GalasaGsonBuilder;
import dev.galasa.ras.couchdb.internal.CouchdbArtifactPath;
import dev.galasa.ras.couchdb.internal.CouchdbDirectoryService;
import dev.galasa.ras.couchdb.internal.CouchdbRasException;
import dev.galasa.ras.couchdb.internal.CouchdbRasFileSystemProvider;
import dev.galasa.ras.couchdb.internal.pojos.Artifacts;
import dev.galasa.ras.couchdb.internal.pojos.LogLines;
import dev.galasa.ras.couchdb.internal.pojos.PutPostResponse;
import dev.galasa.ras.couchdb.internal.pojos.Welcome;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class CouchdbRasStore
implements IResultArchiveStoreService {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final IFramework framework;
    private final URI rasUri;
    private final CloseableHttpClient httpClient;
    private boolean shutdown = false;
    private final Gson gson = GalasaGsonBuilder.build();
    private final CouchdbRasFileSystemProvider provider;
    private final IRun run;
    private String runDocumentId;
    private String runDocumentRevision;
    private long logOrder = 0L;
    private final ArrayList<String> logCache = new ArrayList(100);
    private ArrayList<String> logIds = new ArrayList();
    private ArrayList<String> artifactDocumentId = new ArrayList();
    private String artifactDocumentRev;
    private TestStructure lastTestStructure;

    public CouchdbRasStore(IFramework framework, URI rasUri) throws CouchdbRasException {
        this.framework = framework;
        this.rasUri = rasUri;
        this.httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(rasUri);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new CouchdbRasException("Validation failed to CouchDB server - " + statusLine.toString());
            }
            HttpEntity entity = response.getEntity();
            Welcome welcome = (Welcome)this.gson.fromJson(EntityUtils.toString((HttpEntity)entity), Welcome.class);
            if (!"Welcome".equals(welcome.getCouchdb()) || welcome.getVersion() == null) {
                throw new CouchdbRasException("Validation failed to CouchDB server - invalid json response");
            }
            this.checkVersion(welcome.getVersion(), 2, 3, 1);
            this.checkDatabasePresent(1, "galasa_run");
            this.checkDatabasePresent(1, "galasa_log");
            this.checkDatabasePresent(1, "galasa_artifacts");
            this.checkRunDesignDocument(1);
            this.checkIndex(1, "galasa_run", "runName");
            this.checkIndex(1, "galasa_run", "requestor");
            this.checkIndex(1, "galasa_run", "queued");
            this.checkIndex(1, "galasa_run", "testName");
            this.checkIndex(1, "galasa_run", "bundle");
            this.checkIndex(1, "galasa_run", "result");
            this.logger.debug((Object)("RAS CouchDB at " + this.rasUri.toString() + " validated"));
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CouchdbRasException("Validation failed", e);
        }
        this.run = this.framework.getTestRun();
        if (this.run != null) {
            this.lastTestStructure = new TestStructure();
            this.lastTestStructure.setRunName(this.run.getName());
            try {
                this.updateTestStructure(this.lastTestStructure);
            }
            catch (ResultArchiveStoreException e) {
                throw new CouchdbRasException("Validation failed - unable to create initial run document", e);
            }
            this.createArtifactDocument();
        }
        ResultArchiveStoreFileStore fileStore = new ResultArchiveStoreFileStore();
        this.provider = new CouchdbRasFileSystemProvider((FileStore)fileStore, this);
    }

    private void checkIndex(int attempts, String dbName, String field) throws CouchdbRasException {
        HttpGet httpGet = new HttpGet(this.rasUri + "/galasa_run/_index");
        String idxJson = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            idxJson = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 404) {
                throw new CouchdbRasException("Validation failed of database indexes - " + statusLine.toString());
            }
            if (statusLine.getStatusCode() == 404) {
                idxJson = "{}";
            }
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CouchdbRasException("Validation failed", e);
        }
        JsonObject idx = (JsonObject)this.gson.fromJson(idxJson, JsonObject.class);
        boolean create = true;
        String idxName = field + "-index";
        JsonArray idxs = idx.getAsJsonArray("indexes");
        if (idxs != null) {
            for (int i = 0; i < idxs.size(); ++i) {
                JsonObject o;
                JsonElement name;
                JsonElement elem = idxs.get(i);
                if (!elem.isJsonObject() || (name = (o = (JsonObject)elem).get("name")) == null || !name.isJsonPrimitive() || !((JsonPrimitive)name).isString() || !idxName.equals(name.getAsString())) continue;
                create = false;
                break;
            }
        }
        if (create) {
            this.logger.info((Object)("Updating the galasa_run index " + idxName));
            JsonObject doc = new JsonObject();
            doc.addProperty("name", idxName);
            doc.addProperty("type", "json");
            JsonObject index = new JsonObject();
            doc.add("index", (JsonElement)index);
            JsonArray fields = new JsonArray();
            index.add("fields", (JsonElement)fields);
            JsonObject field1 = new JsonObject();
            fields.add((JsonElement)field1);
            field1.addProperty(field, "asc");
            StringEntity entity = new StringEntity(this.gson.toJson((JsonElement)doc), ContentType.APPLICATION_JSON);
            HttpPost httpPost = new HttpPost(this.rasUri + "/galasa_run/_index");
            httpPost.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
                StatusLine statusLine = response.getStatusLine();
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                int statusCode = statusLine.getStatusCode();
                if (statusCode == 409) {
                    if (++attempts > 10) {
                        throw new CouchdbRasException("Update of galasa_run index failed on CouchDB server due to conflicts, attempted 10 times");
                    }
                    Thread.sleep(1000 + new Random().nextInt(3000));
                    this.checkIndex(attempts, dbName, field);
                    return;
                }
                if (statusLine.getStatusCode() != 200) {
                    throw new CouchdbRasException("Update of galasa_run index failed on CouchDB server - " + statusLine.toString());
                }
            }
            catch (CouchdbRasException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CouchdbRasException("Update of galasa_run index faile", e);
            }
        }
    }

    private void checkDatabasePresent(int attempts, String dbName) throws CouchdbRasException {
        HttpHead httpHead = new HttpHead(this.rasUri + "/" + dbName);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpHead);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                return;
            }
            if (statusLine.getStatusCode() != 404) {
                throw new CouchdbRasException("Validation failed of database " + dbName + " - " + statusLine.toString());
            }
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CouchdbRasException("Validation failed", e);
        }
        this.logger.info((Object)("CouchDB database " + dbName + " is missing,  creating"));
        HttpPut httpPut = new HttpPut(this.rasUri + "/" + dbName);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPut);){
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode == 409) {
                if (++attempts > 10) {
                    throw new CouchdbRasException("Create Database " + dbName + " failed on CouchDB server due to conflicts, attempted 10 times");
                }
                Thread.sleep(1000 + new Random().nextInt(3000));
                this.checkDatabasePresent(attempts, dbName);
                return;
            }
            if (statusLine.getStatusCode() != 201) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw new CouchdbRasException("Create Database " + dbName + " failed on CouchDB server - " + statusLine.toString());
            }
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CouchdbRasException("Create database " + dbName + " failed", e);
        }
    }

    private void checkRunDesignDocument(int attempts) throws CouchdbRasException {
        JsonObject bundleTestnames;
        JsonObject testnames;
        JsonObject result;
        JsonObject requestors;
        JsonObject views;
        HttpGet httpGet = new HttpGet(this.rasUri + "/galasa_run/_design/docs");
        String docJson = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            docJson = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 404) {
                throw new CouchdbRasException("Validation failed of database galasa_run designdocument - " + statusLine.toString());
            }
            if (statusLine.getStatusCode() == 404) {
                docJson = "{}";
            }
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CouchdbRasException("Validation failed", e);
        }
        boolean updated = false;
        JsonObject doc = (JsonObject)this.gson.fromJson(docJson, JsonObject.class);
        doc.remove("_id");
        String rev = null;
        if (doc.has("_rev")) {
            rev = doc.get("_rev").getAsString();
        }
        if ((views = doc.getAsJsonObject("views")) == null) {
            updated = true;
            views = new JsonObject();
            doc.add("views", (JsonElement)views);
        }
        if ((requestors = views.getAsJsonObject("requestors-view")) == null) {
            updated = true;
            requestors = new JsonObject();
            views.add("requestors-view", (JsonElement)requestors);
        }
        if (this.checkView(requestors, "function (doc) { emit(doc.requestor, 1); }", "_count")) {
            updated = true;
        }
        if ((result = views.getAsJsonObject("result-view")) == null) {
            updated = true;
            result = new JsonObject();
            views.add("result-view", (JsonElement)result);
        }
        if (this.checkView(result, "function (doc) { emit(doc.result, 1); }", "_count")) {
            updated = true;
        }
        if ((testnames = views.getAsJsonObject("testnames-view")) == null) {
            updated = true;
            testnames = new JsonObject();
            views.add("testnames-view", (JsonElement)testnames);
        }
        if (this.checkView(testnames, "function (doc) { emit(doc.testName, 1); }", "_count")) {
            updated = true;
        }
        if ((bundleTestnames = views.getAsJsonObject("bundle-testnames-view")) == null) {
            updated = true;
            bundleTestnames = new JsonObject();
            views.add("bundle-testnames-view", (JsonElement)testnames);
        }
        if (this.checkView(bundleTestnames, "function (doc) { emit(doc.bundle + '/' + doc.testName, 1); }", "_count")) {
            updated = true;
        }
        if (updated) {
            this.logger.info((Object)"Updating the galasa_run design document");
            StringEntity entity = new StringEntity(this.gson.toJson((JsonElement)doc), ContentType.APPLICATION_JSON);
            HttpPut httpPut = new HttpPut(this.rasUri + "/galasa_run/_design/docs");
            httpPut.setEntity((HttpEntity)entity);
            if (rev != null) {
                httpPut.addHeader("ETaq", "\"" + rev + "\"");
            }
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPut);){
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (statusCode == 409) {
                    if (++attempts > 10) {
                        throw new CouchdbRasException("Update of galasa_run design document failed on CouchDB server due to conflicts, attempted 10 times");
                    }
                    Thread.sleep(1000 + new Random().nextInt(3000));
                    this.checkRunDesignDocument(attempts);
                    return;
                }
                if (statusCode != 201) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                    throw new CouchdbRasException("Update of galasa_run design document failed on CouchDB server - " + statusLine.toString());
                }
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            catch (CouchdbRasException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CouchdbRasException("Update of galasa_run design document faile", e);
            }
        }
    }

    private boolean checkView(JsonObject view, String targetMap, String targetReduce) {
        boolean updated = false;
        if (this.checkViewString(view, "map", targetMap)) {
            updated = true;
        }
        if (this.checkViewString(view, "reduce", targetReduce)) {
            updated = true;
        }
        if (this.checkViewString(view, "language", "javascript")) {
            updated = true;
        }
        return updated;
    }

    private boolean checkViewString(JsonObject view, String field, String value) {
        JsonElement element = view.get(field);
        if (element == null) {
            view.addProperty(field, value);
            return true;
        }
        if (!element.isJsonPrimitive() || !((JsonPrimitive)element).isString()) {
            view.addProperty(field, value);
            return true;
        }
        String actualValue = element.getAsString();
        if (!value.equals(actualValue)) {
            view.addProperty(field, value);
            return true;
        }
        return false;
    }

    private void checkVersion(String version, int minVersion, int minRelease, int minModification) throws CouchdbRasException {
        String minVRM = minVersion + "." + minRelease + "." + minModification;
        Pattern vrm = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)$");
        Matcher m = vrm.matcher(version);
        if (!m.find()) {
            throw new CouchdbRasException("Invalid CouchDB version " + version);
        }
        int actualVersion = 0;
        int actualRelease = 0;
        int actualModification = 0;
        try {
            actualVersion = Integer.parseInt(m.group(1));
            actualRelease = Integer.parseInt(m.group(2));
            actualModification = Integer.parseInt(m.group(3));
        }
        catch (NumberFormatException e) {
            throw new CouchdbRasException("Unable to determine CouchDB version " + version, e);
        }
        if (actualVersion > minVersion) {
            return;
        }
        if (actualVersion < minVersion) {
            throw new CouchdbRasException("CouchDB version " + version + " is below minimum " + minVRM);
        }
        if (actualRelease > minRelease) {
            return;
        }
        if (actualRelease < minRelease) {
            throw new CouchdbRasException("CouchDB version " + version + " is below minimum " + minVRM);
        }
        if (actualModification > minModification) {
            return;
        }
        if (actualModification < minModification) {
            throw new CouchdbRasException("CouchDB version " + version + " is below minimum " + minVRM);
        }
    }

    private void createArtifactDocument() throws CouchdbRasException {
        Artifacts artifacts = new Artifacts();
        artifacts.runId = this.runDocumentId;
        artifacts.runName = this.run.getName();
        String jsonArtifacts = this.gson.toJson((Object)artifacts);
        HttpPost request = new HttpPost(this.rasUri + "/galasa_artifacts");
        request.setEntity((HttpEntity)new StringEntity(jsonArtifacts, StandardCharsets.UTF_8));
        request.addHeader("Accept", "application/json");
        request.addHeader("Content-Type", "application/json");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 201) {
                throw new CouchdbRasException("Unable to store the artifacts document - " + statusLine.toString());
            }
            HttpEntity entity = response.getEntity();
            PutPostResponse putPostResponse = (PutPostResponse)this.gson.fromJson(EntityUtils.toString((HttpEntity)entity), PutPostResponse.class);
            if (putPostResponse.id == null || putPostResponse.rev == null) {
                throw new CouchdbRasException("Unable to store the artifacts document - Invalid JSON response");
            }
            this.artifactDocumentId.add(putPostResponse.id);
            this.artifactDocumentRev = putPostResponse.rev;
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CouchdbRasException("Unable to store the artifacts document", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLog(@NotNull String message) throws ResultArchiveStoreException {
        if (this.run == null) {
            throw new ResultArchiveStoreException("Not a run");
        }
        String[] lines = message.split("\r\n?|\n");
        ArrayList<String> arrayList = this.logCache;
        synchronized (arrayList) {
            this.logCache.addAll(Arrays.asList(lines));
            if (this.logCache.size() >= 100) {
                this.flushLogCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushLogCache() throws ResultArchiveStoreException {
        LogLines logLines = new LogLines();
        ArrayList<String> arrayList = this.logCache;
        synchronized (arrayList) {
            if (this.logCache.isEmpty()) {
                return;
            }
            logLines.lines = new ArrayList<String>(this.logCache);
            ++this.logOrder;
            logLines.order = this.logOrder;
            this.logCache.clear();
        }
        logLines.runName = this.run.getName();
        logLines.runId = this.runDocumentId;
        String jsonStructure = this.gson.toJson((Object)logLines);
        HttpPost request = new HttpPost(this.rasUri + "/galasa_log");
        request.setEntity((HttpEntity)new StringEntity(jsonStructure, StandardCharsets.UTF_8));
        request.addHeader("Accept", "application/json");
        request.addHeader("Content-Type", "application/json");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 201) {
                throw new CouchdbRasException("Unable to store the test log - " + statusLine.toString());
            }
            HttpEntity entity = response.getEntity();
            PutPostResponse putPostResponse = (PutPostResponse)this.gson.fromJson(EntityUtils.toString((HttpEntity)entity), PutPostResponse.class);
            if (putPostResponse.id == null || putPostResponse.rev == null) {
                throw new CouchdbRasException("Unable to store the test log - Invalid JSON response");
            }
            this.logIds.add(putPostResponse.id);
            this.updateTestStructure(this.lastTestStructure);
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResultArchiveStoreException("Unable to store the test log", (Throwable)e);
        }
    }

    public void writeLog(@NotNull List<String> messages) throws ResultArchiveStoreException {
        if (this.run == null) {
            throw new ResultArchiveStoreException("Not a run");
        }
        for (String message : messages) {
            this.writeLog(message);
        }
    }

    public synchronized void updateTestStructure(@NotNull TestStructure testStructure) throws ResultArchiveStoreException {
        HttpPost request;
        if (this.run == null) {
            throw new ResultArchiveStoreException("Not a run");
        }
        this.lastTestStructure = testStructure;
        this.lastTestStructure.setLogRecordIds(this.logIds);
        this.lastTestStructure.setArtifactRecordIds(this.artifactDocumentId);
        this.lastTestStructure.normalise();
        String jsonStructure = this.gson.toJson((Object)testStructure);
        if (this.runDocumentId == null) {
            request = new HttpPost(this.rasUri + "/galasa_run");
        } else {
            request = new HttpPut(this.rasUri + "/galasa_run/" + this.runDocumentId);
            request.addHeader("If-Match", this.runDocumentRevision);
        }
        request.setEntity((HttpEntity)new StringEntity(jsonStructure, StandardCharsets.UTF_8));
        request.addHeader("Accept", "application/json");
        request.addHeader("Content-Type", "application/json");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 201) {
                if (statusLine.getStatusCode() == 409) {
                    this.logger.error((Object)"The run document has been updated by another engine, terminating now to avoid corruption");
                    System.exit(0);
                }
                throw new CouchdbRasException("Unable to store the test structure - " + statusLine.toString());
            }
            HttpEntity entity = response.getEntity();
            PutPostResponse putPostResponse = (PutPostResponse)this.gson.fromJson(EntityUtils.toString((HttpEntity)entity), PutPostResponse.class);
            if (putPostResponse.id == null || putPostResponse.rev == null) {
                throw new CouchdbRasException("Unable to store the test structure - Invalid JSON response");
            }
            this.runDocumentId = putPostResponse.id;
            this.runDocumentRevision = putPostResponse.rev;
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResultArchiveStoreException("Unable to store the test structure", (Throwable)e);
        }
    }

    public void retrieveArtifact(CouchdbArtifactPath path, Path cachePath) throws CouchdbRasException {
        String encodedPath;
        String artifactRecordId = path.getArtifactRecordId();
        try {
            encodedPath = URLEncoder.encode(path.toString(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CouchdbRasException("Problem encoding artifact path", e);
        }
        HttpGet httpGet = new HttpGet(this.rasUri + "/galasa_artifacts/" + artifactRecordId + "/" + encodedPath);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 404) {
                throw new CouchdbRasException("Not found - " + path.toString());
            }
            if (statusLine.getStatusCode() != 200) {
                throw new CouchdbRasException("Unable to find artifact - " + statusLine.toString());
            }
            HttpEntity entity = response.getEntity();
            Files.copy(entity.getContent(), cachePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CouchdbRasException("Unable to find runs", e);
        }
    }

    public String getLog(TestStructure ts) throws CouchdbRasException {
        StringBuilder sb = new StringBuilder();
        for (String logRecordId : ts.getLogRecordIds()) {
            HttpGet httpGet = new HttpGet(this.rasUri + "/galasa_log/" + logRecordId);
            httpGet.addHeader("Accept", "application/json");
            try {
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
                Throwable throwable = null;
                try {
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine.getStatusCode() == 404) continue;
                    if (statusLine.getStatusCode() != 200) {
                        throw new CouchdbRasException("Unable to find logs - " + statusLine.toString());
                    }
                    HttpEntity entity = response.getEntity();
                    String responseEntity = EntityUtils.toString((HttpEntity)entity);
                    LogLines logLines = (LogLines)this.gson.fromJson(responseEntity, LogLines.class);
                    if (logLines.lines == null) continue;
                    for (String line : logLines.lines) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(line);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (CouchdbRasException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CouchdbRasException("Unable to find runs", e);
            }
        }
        return sb.toString();
    }

    public Path getStoredArtifactsRoot() {
        if (this.run == null) {
            return null;
        }
        return this.provider.getActualFileSystem().getPath("/", new String[0]);
    }

    public void flush() {
        try {
            this.flushLogCache();
        }
        catch (ResultArchiveStoreException e) {
            this.logger.error((Object)"Error with heartbeat flush", (Throwable)e);
        }
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            this.flushLogCache();
        }
        catch (ResultArchiveStoreException e) {
            this.logger.error((Object)"Error with shutdown flush", (Throwable)e);
        }
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getArtifactDocumentId() {
        return this.artifactDocumentId.get(0);
    }

    public String getArtifactDocumentRev() {
        return this.artifactDocumentRev;
    }

    public URI getCouchdbUri() {
        return this.rasUri;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void updateArtifactDocumentRev(String newArtifactDocumentRev) {
        this.artifactDocumentRev = newArtifactDocumentRev;
    }

    @NotNull
    public List<IResultArchiveStoreDirectoryService> getDirectoryServices() {
        ArrayList<IResultArchiveStoreDirectoryService> dirs = new ArrayList<IResultArchiveStoreDirectoryService>();
        dirs.add(new CouchdbDirectoryService(this));
        return dirs;
    }

    public String calculateRasRunId() {
        if (this.runDocumentId == null) {
            return null;
        }
        return "cdb-" + this.runDocumentId;
    }
}

