/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ras.couchdb.internal;

import dev.galasa.ResultArchiveStoreContentType;
import dev.galasa.ras.couchdb.internal.CouchdbArtifactPath;
import dev.galasa.ras.couchdb.internal.CouchdbRasException;
import dev.galasa.ras.couchdb.internal.CouchdbRasFileSystemProvider;
import dev.galasa.ras.couchdb.internal.CouchdbRasStore;
import dev.galasa.ras.couchdb.internal.pojos.PutPostResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.util.EntityUtils;

public class CouchdbRasWriteByteChannel
implements SeekableByteChannel {
    private static final Log logger = LogFactory.getLog(CouchdbRasWriteByteChannel.class);
    private static final Charset UTF8 = Charset.forName("utf-8");
    private final Path cachePath;
    private final SeekableByteChannel cacheByteChannel;
    private final Path remotePath;
    private final ResultArchiveStoreContentType remoteContentType;
    private final CouchdbRasStore couchdbRasStore;
    private final CouchdbRasFileSystemProvider couchdbRasFileSystemProvider;

    CouchdbRasWriteByteChannel(CouchdbRasFileSystemProvider couchdbRasFileSystemProvider, CouchdbRasStore couchdbRasStore, Path remotePath, ResultArchiveStoreContentType remoteContentType, Set<? extends OpenOption> options, FileAttribute<?>[] attrs) throws IOException {
        this.couchdbRasStore = couchdbRasStore;
        this.couchdbRasFileSystemProvider = couchdbRasFileSystemProvider;
        this.remotePath = remotePath;
        this.remoteContentType = remoteContentType != null ? remoteContentType : ResultArchiveStoreContentType.TEXT;
        this.cachePath = Files.createTempFile("galasa_couchdb", "temp", new FileAttribute[0]);
        this.cacheByteChannel = Files.newByteChannel(this.cachePath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public boolean isOpen() {
        return this.cacheByteChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.cacheByteChannel.close();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            String encodedRemotePath = URLEncoder.encode(this.remotePath.toString(), UTF8.name());
            HttpPut request = new HttpPut(this.couchdbRasStore.getCouchdbUri() + "/galasa_artifacts/" + this.couchdbRasStore.getArtifactDocumentId() + "/" + encodedRemotePath);
            request.setEntity((HttpEntity)new FileEntity(this.cachePath.toFile()));
            request.addHeader("Accept", "application/json");
            request.addHeader("Content-Type", this.remoteContentType.value());
            request.addHeader("If-Match", this.couchdbRasStore.getArtifactDocumentRev());
            try (CloseableHttpResponse response = this.couchdbRasStore.getHttpClient().execute((HttpUriRequest)request);){
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() != 201) {
                    if (statusLine.getStatusCode() == 409) {
                        logger.error((Object)"The run artifact document has been updated by another engine, terminating now to avoid corruption");
                        System.exit(0);
                    }
                    throw new IOException("Unable to store the artifact attachment - " + statusLine.toString());
                }
                HttpEntity entity = response.getEntity();
                PutPostResponse putPostResponse = (PutPostResponse)this.couchdbRasStore.getGson().fromJson(EntityUtils.toString((HttpEntity)entity), PutPostResponse.class);
                if (putPostResponse.id == null || putPostResponse.rev == null) {
                    throw new CouchdbRasException("Unable to store the test structure - Invalid JSON response");
                }
                this.couchdbRasStore.updateArtifactDocumentRev(putPostResponse.rev);
                this.couchdbRasFileSystemProvider.addPath((CouchdbArtifactPath)((Object)this.remotePath));
                logger.info((Object)("Stored artifact " + this.remotePath + ", length=" + Files.size(this.cachePath) + ", contentType=" + this.remoteContentType.value()));
            }
            catch (Exception e) {
                throw new IOException("Unable to store artifact attachment", e);
            }
            finally {
                try {
                    Files.delete(this.cachePath);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.cacheByteChannel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.cacheByteChannel.write(src);
    }

    @Override
    public long position() throws IOException {
        return this.cacheByteChannel.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        return this.cacheByteChannel.position(newPosition);
    }

    @Override
    public long size() throws IOException {
        return this.cacheByteChannel.size();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        return this.cacheByteChannel.truncate(size);
    }
}

