/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ras.couchdb.internal;

import dev.galasa.framework.spi.IRunResult;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.teststructure.TestStructure;
import dev.galasa.ras.couchdb.internal.CouchdbDirectoryService;
import dev.galasa.ras.couchdb.internal.CouchdbRasStore;
import dev.galasa.ras.couchdb.internal.pojos.TestStructureCouchdb;
import java.nio.file.Path;

public class CouchdbRunResult
implements IRunResult {
    private final TestStructureCouchdb testStructure;
    private final Path path;
    private final CouchdbRasStore store;

    public CouchdbRunResult(CouchdbRasStore store, TestStructureCouchdb testStructure, Path path) {
        this.store = store;
        this.testStructure = testStructure == null ? new TestStructureCouchdb() : testStructure;
        this.path = path;
    }

    public TestStructure getTestStructure() throws ResultArchiveStoreException {
        return this.testStructure;
    }

    public Path getArtifactsRoot() throws ResultArchiveStoreException {
        return this.path;
    }

    public String getLog() throws ResultArchiveStoreException {
        return this.store.getLog(this.testStructure);
    }

    public void discard() throws ResultArchiveStoreException {
        CouchdbDirectoryService storeService = (CouchdbDirectoryService)this.store.getDirectoryServices().get(0);
        storeService.discardRun(this.testStructure._id);
    }

    public String getRunId() {
        return "cdb-" + this.testStructure._id;
    }
}

