/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.selenium.internal;

import dev.galasa.selenium.IFirefoxOptions;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;

public class FirefoxOptionsImpl
implements IFirefoxOptions {
    public FirefoxOptions options = new FirefoxOptions();
    private boolean isLegacy;

    protected FirefoxOptions get() {
        return this.options;
    }

    @Override
    public FirefoxOptions getOptions() {
        return this.options;
    }

    @Override
    public void addPreference(String key, String value) {
        this.options.addPreference(key, value);
    }

    @Override
    public void addPreference(String key, Integer value) {
        this.options.addPreference(key, value);
    }

    @Override
    public void addPreference(String key, Boolean value) {
        this.options.addPreference(key, value);
    }

    @Override
    public void setProfile(FirefoxProfile profile) {
        this.options.setProfile(profile);
    }

    @Override
    @Deprecated(forRemoval=true, since="0.39.0")
    public void setHeadless(boolean isHeadless) {
        if (!isHeadless) {
            throw new UnsupportedOperationException("setHeadless(false) is no longer supported in Selenium 4. See the Galasa 0.39.0 release notes for guidance on migration.");
        }
        this.options.addArguments(List.of("-headless"));
    }

    @Override
    public void setAcceptInsecureCerts(boolean bool) {
        this.options.setAcceptInsecureCerts(bool);
    }

    @Override
    public void setBinary(Path path) {
        this.options.setBinary(path);
    }

    @Override
    public void setBinary(String path) {
        this.options.setBinary(path);
    }

    @Override
    public void addArguments(String ... arguments) {
        this.options.addArguments(arguments);
    }

    @Override
    public void addArguments(List<String> arguments) {
        this.options.addArguments(arguments);
    }

    @Override
    public void setCapability(String key, Object value) {
        this.options.setCapability(key, value);
    }

    @Override
    @Deprecated(forRemoval=true, since="0.39.0")
    public void setLegacy(boolean isLegacy) {
        this.options.setCapability("marionette", !isLegacy);
        this.isLegacy = isLegacy;
    }

    @Override
    public void setLogLevel(Level level) {
        this.options.setLogLevel(FirefoxDriverLogLevel.fromLevel(level));
    }

    @Override
    public Map<String, Object> asMap() {
        return this.options.asMap();
    }

    @Override
    public Optional<FirefoxBinary> getBinaryOrNull() {
        return this.options.getBinaryOrNull();
    }

    @Override
    public String getBrowserName() {
        return this.options.getBrowserName();
    }

    @Override
    public Platform getPlatform() {
        return this.options.getPlatformName();
    }

    @Override
    public FirefoxProfile getProfile() {
        return this.options.getProfile();
    }

    @Override
    public String getVersion() {
        return this.options.getBrowserVersion();
    }

    @Override
    public boolean is(String capabilityName) {
        return this.options.is(capabilityName);
    }

    @Override
    public boolean isJavascriptEnabled() {
        return this.is("javascriptEnabled");
    }

    @Override
    @Deprecated(forRemoval=true, since="0.39.0")
    public boolean isLegacy() {
        return this.isLegacy;
    }

    @Override
    public void setPageLoadStrategy(PageLoadStrategy strategy) {
        this.options.setPageLoadStrategy(strategy);
    }

    @Override
    public void setProxy(Proxy proxy) {
        this.options.setProxy(proxy);
    }

    @Override
    public void setUnhandledPromptBehaviour(UnexpectedAlertBehaviour behaviour) {
        this.options.setUnhandledPromptBehaviour(behaviour);
    }
}

