/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.selenium.internal.properties;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.selenium.SeleniumManagerException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={SeleniumPropertiesSingleton.class}, immediate=true)
public class SeleniumPropertiesSingleton {
    private static SeleniumPropertiesSingleton instance;
    private IConfigurationPropertyStoreService cps;

    @Activate
    public void activate() {
        instance = this;
    }

    @Deactivate
    public void deacivate() {
        instance = null;
    }

    public static IConfigurationPropertyStoreService cps() throws SeleniumManagerException {
        if (instance != null) {
            return SeleniumPropertiesSingleton.instance.cps;
        }
        throw new SeleniumManagerException("Attempt to access manager CPS before it has been initialised");
    }

    public static void setCps(IConfigurationPropertyStoreService cps) throws SeleniumManagerException {
        if (instance != null) {
            SeleniumPropertiesSingleton.instance.cps = cps;
            return;
        }
        throw new SeleniumManagerException("Attempt to set manager CPS before instance created");
    }
}

