/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.auto.service.AutoService;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumDriverInfo;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;

@AutoService(value={WebDriverInfo.class})
public class ChromeDriverInfo
extends ChromiumDriverInfo {
    private static final Logger LOG = Logger.getLogger(ChromeDriverInfo.class.getName());

    public String getDisplayName() {
        return "Chrome";
    }

    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", Browser.CHROME.browserName());
    }

    public boolean isSupporting(Capabilities capabilities) {
        return Browser.CHROME.is(capabilities) || capabilities.getCapability("goog:chromeOptions") != null;
    }

    public boolean isSupportingCdp() {
        return true;
    }

    public boolean isSupportingBiDi() {
        return true;
    }

    public boolean isAvailable() {
        return new DriverFinder((DriverService)ChromeDriverService.createDefaultService(), this.getCanonicalCapabilities()).isAvailable();
    }

    public boolean isPresent() {
        return new DriverFinder((DriverService)ChromeDriverService.createDefaultService(), this.getCanonicalCapabilities()).isPresent();
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        ChromeDriver driver = new ChromeDriver(new ChromeOptions().merge(capabilities));
        return Optional.of(driver);
    }
}

