/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.AcceptedW3CCapabilityKeys;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.http.Contents;

public class NewSessionPayload
implements Closeable {
    private static final Dialect DEFAULT_DIALECT = Dialect.W3C;
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = new AcceptedW3CCapabilityKeys();
    private final Json json = new Json();
    private final Contents.Supplier supplier;
    private final Set<Dialect> dialects;

    private NewSessionPayload(Contents.Supplier supplier) {
        this.supplier = supplier;
        LinkedHashSet<Dialect> dialects = new LinkedHashSet<Dialect>();
        try {
            if (this.isW3C()) {
                dialects.add(Dialect.W3C);
            }
            this.dialects = Set.copyOf(dialects);
            this.validate();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static NewSessionPayload create(Capabilities caps) {
        Require.nonNull((String)"Capabilities", (Object)caps);
        return NewSessionPayload.create(Collections.singleton(caps));
    }

    public static NewSessionPayload create(Collection<Capabilities> caps) {
        return NewSessionPayload.create(Map.of("capabilities", Map.of("firstMatch", caps.stream().map(Capabilities::asMap).collect(Collectors.toList()))));
    }

    public static NewSessionPayload create(Map<String, ?> source) {
        Require.precondition((boolean)source.containsKey("capabilities"), (String)"New session payload must contain capabilities", (Object[])new Object[0]);
        return new NewSessionPayload(Contents.asJson((Object)Require.nonNull((String)"Payload", source)));
    }

    public static NewSessionPayload create(Contents.Supplier supplier) {
        return new NewSessionPayload(supplier);
    }

    public Contents.Supplier getSupplier() {
        return this.supplier;
    }

    private void validate() throws IOException {
        Map<String, Object> alwaysMatch = this.getAlwaysMatch();
        if (alwaysMatch == null) {
            alwaysMatch = Map.of();
        }
        Map<String, Object> always = alwaysMatch;
        Collection<Map<String, Object>> firsts = this.getFirstMatches();
        if (firsts == null) {
            firsts = List.of(Map.of());
        }
        if (firsts.isEmpty()) {
            throw new IllegalArgumentException("First match w3c capabilities is zero length");
        }
        firsts.stream().peek(map -> {
            HashSet overlap = new HashSet(always.keySet());
            overlap.removeIf(e -> !map.keySet().contains(e));
            if (!overlap.isEmpty()) {
                throw new IllegalArgumentException("Overlapping keys between w3c always and first match capabilities: " + String.valueOf(overlap));
            }
        }).map(first -> {
            HashMap toReturn = new HashMap();
            toReturn.putAll(always);
            toReturn.putAll(first);
            return toReturn;
        }).peek(map -> {
            List nullKeys = map.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
            if (!nullKeys.isEmpty()) {
                throw new IllegalArgumentException("Null values found in w3c capabilities. Keys are: " + String.valueOf(nullKeys));
            }
        }).peek(map -> {
            List illegalKeys = map.keySet().stream().filter(ACCEPTED_W3C_PATTERNS.negate()).sorted().collect(Collectors.toList());
            if (!illegalKeys.isEmpty()) {
                throw new IllegalArgumentException("Illegal key values seen in w3c capabilities: " + String.valueOf(illegalKeys));
            }
        }).forEach(map -> {});
    }

    public void writeTo(Appendable appendable) throws IOException {
        try (JsonOutput json = new Json().newOutput(appendable);){
            json.beginObject();
            json.name("capabilities");
            json.beginObject();
            json.name("firstMatch");
            json.beginArray();
            this.getW3C().forEach(json::write);
            json.endArray();
            json.endObject();
            this.writeMetaData(json);
            json.endObject();
        }
    }

    private void writeMetaData(JsonOutput out) throws IOException {
        try (Reader reader = Contents.reader((Contents.Supplier)this.supplier, (Charset)StandardCharsets.UTF_8);
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            block16: while (input.hasNext()) {
                String name;
                switch (name = input.nextName()) {
                    case "capabilities": {
                        input.skipValue();
                        continue block16;
                    }
                }
                out.name(name);
                out.write(input.read((Type)((Object)Object.class)));
            }
        }
    }

    public Stream<Capabilities> stream() {
        try {
            return this.getW3C().filter(Objects::nonNull).distinct().map(ImmutableCapabilities::new);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Set<Dialect> getDownstreamDialects() {
        return this.dialects.isEmpty() ? Set.of(DEFAULT_DIALECT) : this.dialects;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getMetadata() {
        Set<String> ignoredMetadataKeys = Set.of("capabilities");
        try (Reader reader = Contents.reader((Contents.Supplier)this.supplier, (Charset)StandardCharsets.UTF_8);){
            JsonInput input = this.json.newInput(reader);
            try {
                LinkedHashMap toReturn = new LinkedHashMap();
                input.beginObject();
                while (input.hasNext()) {
                    String name = input.nextName();
                    if (ignoredMetadataKeys.contains(name)) {
                        input.skipValue();
                        continue;
                    }
                    Object value = input.read((Type)((Object)Object.class));
                    if (value == null) continue;
                    toReturn.put(name, value);
                }
                input.endObject();
                Map<String, Object> map = Map.copyOf(toReturn);
                if (input != null) {
                    input.close();
                }
                return map;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.supplier.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Stream<Map<String, Object>> getW3C() throws IOException {
        Stream<Map> fromW3c;
        Map<String, Object> alwaysMatch = this.getAlwaysMatch();
        Collection<Map<String, Object>> firsts = this.getFirstMatches();
        if (alwaysMatch == null && firsts == null) {
            fromW3c = Stream.of(new Map[0]);
        } else {
            if (alwaysMatch == null) {
                alwaysMatch = Map.of();
            }
            Map<String, Object> always = alwaysMatch;
            if (firsts == null) {
                firsts = List.of(Map.of());
            }
            fromW3c = firsts.stream().map(first -> {
                LinkedHashMap merged = new LinkedHashMap(always);
                merged.putAll(first);
                return Map.copyOf(merged);
            });
        }
        return fromW3c.distinct();
    }

    private boolean isW3C() throws IOException {
        try (Reader reader = Contents.reader((Contents.Supplier)this.supplier, (Charset)StandardCharsets.UTF_8);
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            while (input.hasNext()) {
                String name = input.nextName();
                if ("capabilities".equals(name)) {
                    boolean bl = true;
                    return bl;
                }
                input.skipValue();
            }
        }
        return false;
    }

    private Map<String, Object> getAlwaysMatch() throws IOException {
        try (Reader reader = Contents.reader((Contents.Supplier)this.supplier, (Charset)StandardCharsets.UTF_8);
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            while (input.hasNext()) {
                String name = input.nextName();
                if ("capabilities".equals(name)) {
                    input.beginObject();
                    while (input.hasNext()) {
                        name = input.nextName();
                        if ("alwaysMatch".equals(name)) {
                            Map map = (Map)input.read(Json.MAP_TYPE);
                            return map;
                        }
                        input.skipValue();
                    }
                    input.endObject();
                    continue;
                }
                input.skipValue();
            }
        }
        return Map.of();
    }

    private Collection<Map<String, Object>> getFirstMatches() throws IOException {
        try (Reader reader = Contents.reader((Contents.Supplier)this.supplier, (Charset)StandardCharsets.UTF_8);
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            while (input.hasNext()) {
                String name = input.nextName();
                if ("capabilities".equals(name)) {
                    input.beginObject();
                    while (input.hasNext()) {
                        name = input.nextName();
                        if ("firstMatch".equals(name)) {
                            Collection collection = (Collection)input.read(Json.LIST_OF_MAPS_TYPE);
                            return collection;
                        }
                        input.skipValue();
                    }
                    input.endObject();
                    continue;
                }
                input.skipValue();
            }
        }
        return List.of(Map.of());
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        try {
            this.writeTo(res);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res.toString();
    }
}

