/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.RemoteWebDriver;

class ShadowRoot
implements SearchContext,
WrapsDriver {
    private final RemoteWebDriver parent;
    private final String id;

    ShadowRoot(RemoteWebDriver parent, String id) {
        this.parent = (RemoteWebDriver)Require.nonNull((String)"Owning remote webdriver", (Object)parent);
        this.id = (String)Require.nonNull((String)"Shadow root ID", (Object)id);
    }

    @Override
    public List<WebElement> findElements(By by) {
        return this.parent.findElements(this, (using, value) -> DriverCommand.FIND_ELEMENTS_FROM_SHADOW_ROOT(this.id, using, String.valueOf(value)), by);
    }

    @Override
    public WebElement findElement(By by) {
        return this.parent.findElement(this, (using, value) -> DriverCommand.FIND_ELEMENT_FROM_SHADOW_ROOT(this.id, using, String.valueOf(value)), by);
    }

    @Override
    public WebDriver getWrappedDriver() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    private Map<String, Object> toJson() {
        return Collections.singletonMap(Dialect.W3C.getShadowRootElementKey(), this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShadowRoot that = (ShadowRoot)o;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.id);
    }
}

