/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos.internal;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResourceManagement;
import dev.galasa.zos.internal.ZosProvisionedImageImpl;
import dev.galasa.zos.internal.ZosResourceManagement;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SlotResourceMonitor
implements Runnable {
    private final IFramework framework;
    private final IResourceManagement resourceManagement;
    private final IDynamicStatusStoreService dss;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Pattern slotRunPattern = Pattern.compile("^slot\\.run\\.(\\w+)\\.image\\.(\\w+)\\.slot\\.(\\w+)$");

    public SlotResourceMonitor(IFramework framework, IResourceManagement resourceManagement, IDynamicStatusStoreService dss, ZosResourceManagement zosResourceManagement, IConfigurationPropertyStoreService cps) {
        this.framework = framework;
        this.resourceManagement = resourceManagement;
        this.dss = dss;
        this.logger.info((Object)"zOS Slot resource monitor initialised");
    }

    @Override
    public void run() {
        this.logger.info((Object)"Starting Run Slot search");
        try {
            Map slotRuns = this.dss.getPrefix("slot.run.");
            Set activeRunNames = this.framework.getFrameworkRuns().getActiveRunNames();
            for (String key : slotRuns.keySet()) {
                String runName;
                Matcher matcher = this.slotRunPattern.matcher(key);
                if (!matcher.find() || activeRunNames.contains(runName = matcher.group(1))) continue;
                String imageId = matcher.group(2);
                String slot = matcher.group(3);
                this.logger.info((Object)("Discarding slot " + slot + " on image " + imageId + " as run " + runName + " has gone"));
                try {
                    ZosProvisionedImageImpl.deleteDss(runName, imageId, slot, this.dss);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to discard slot " + slot + " on image " + imageId + " as run " + runName));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failure during slot scan", (Throwable)e);
        }
        this.resourceManagement.resourceManagementRunSuccessful();
        this.logger.info((Object)"Finished Run Slot search");
    }

    public void runFinishedOrDeleted(String runName) {
        try {
            Map slotRuns = this.dss.getPrefix("slot.run." + runName + ".");
            for (String key : slotRuns.keySet()) {
                Matcher matcher = this.slotRunPattern.matcher(key);
                if (!matcher.find()) continue;
                String imageId = matcher.group(2);
                String slot = matcher.group(3);
                this.logger.info((Object)("Discarding slot " + slot + " on image " + imageId + " as run " + runName + " has gone"));
                try {
                    ZosProvisionedImageImpl.deleteDss(runName, imageId, slot, this.dss);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to discard slot " + slot + " on image " + imageId + " as run " + runName));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to delete slots for run " + runName));
        }
    }
}

