/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos.internal;

import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.ipnetwork.IIpPort;
import dev.galasa.ipnetwork.IpNetworkManagerException;
import dev.galasa.ipnetwork.spi.AbstractGenericIpHost;
import dev.galasa.zos.internal.ZosIpPortImpl;
import dev.galasa.zos.internal.ZosManagerImpl;

public class ZosIpHostImpl
extends AbstractGenericIpHost {
    private ZosManagerImpl zosManager;
    private String image;

    public ZosIpHostImpl(ZosManagerImpl zosManager, String imageId) throws IpNetworkManagerException, CredentialsException {
        super(zosManager.getCPS(), zosManager.getDSS(), zosManager.getFramework().getCredentialsService(), "image", imageId);
        this.zosManager = zosManager;
        this.image = imageId;
    }

    public IIpPort provisionPort(String type) throws IpNetworkManagerException {
        try {
            String allocatedPort = this.zosManager.getZosPortController().allocatePort(this.image);
            return new ZosIpPortImpl(this, Integer.parseInt(allocatedPort), type);
        }
        catch (Exception exception) {
            throw new IpNetworkManagerException("Exception whilst allocating a z/OS port from the pool");
        }
    }
}

