/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos.internal;

import dev.galasa.ICredentials;
import dev.galasa.ManagerException;
import dev.galasa.ResultArchiveStoreContentType;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.AnnotatedField;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.GenerateAnnotatedField;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IManager;
import dev.galasa.framework.spi.ResourceUnavailableException;
import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.framework.spi.creds.ICredentialsService;
import dev.galasa.framework.spi.language.GalasaTest;
import dev.galasa.framework.spi.utils.DssUtils;
import dev.galasa.ipnetwork.IIpHost;
import dev.galasa.ipnetwork.IIpPort;
import dev.galasa.ipnetwork.spi.IIpNetworkManagerSpi;
import dev.galasa.zos.IZosImage;
import dev.galasa.zos.ZosImage;
import dev.galasa.zos.ZosIpHost;
import dev.galasa.zos.ZosIpPort;
import dev.galasa.zos.ZosManagerException;
import dev.galasa.zos.ZosManagerField;
import dev.galasa.zos.internal.ZosBaseImageImpl;
import dev.galasa.zos.internal.ZosDseImageImpl;
import dev.galasa.zos.internal.ZosPoolPorts;
import dev.galasa.zos.internal.ZosProvisionedImageImpl;
import dev.galasa.zos.internal.properties.BatchExtraBundle;
import dev.galasa.zos.internal.properties.ClusterIdForTag;
import dev.galasa.zos.internal.properties.ClusterImages;
import dev.galasa.zos.internal.properties.ConsoleExtraBundle;
import dev.galasa.zos.internal.properties.DseClusterIdForTag;
import dev.galasa.zos.internal.properties.DseImageIdForTag;
import dev.galasa.zos.internal.properties.FileExtraBundle;
import dev.galasa.zos.internal.properties.ImageIdForTag;
import dev.galasa.zos.internal.properties.JavaHome;
import dev.galasa.zos.internal.properties.LibertyInstallDir;
import dev.galasa.zos.internal.properties.RunDatasetHLQ;
import dev.galasa.zos.internal.properties.RunUNIXPathPrefix;
import dev.galasa.zos.internal.properties.TSOCommandExtraBundle;
import dev.galasa.zos.internal.properties.UNIXCommandExtraBundle;
import dev.galasa.zos.internal.properties.ZosConnectInstallDir;
import dev.galasa.zos.internal.properties.ZosPropertiesSingleton;
import dev.galasa.zos.spi.IZosManagerSpi;
import dev.galasa.zos.spi.ZosImageDependencyField;
import dev.galasa.zosbatch.IZosBatchJob;
import dev.galasa.zosbatch.IZosBatchJobOutputSpoolFile;
import dev.galasa.zosbatch.IZosBatchJobname;
import dev.galasa.zosbatch.ZosBatchException;
import dev.galasa.zosbatch.ZosBatchManagerException;
import dev.galasa.zosbatch.internal.ZosBatchJobOutputImpl;
import dev.galasa.zosbatch.internal.ZosBatchJobOutputSpoolFileImpl;
import dev.galasa.zosbatch.internal.ZosBatchJobnameImpl;
import dev.galasa.zosbatch.internal.properties.BatchRestrictToImage;
import dev.galasa.zosbatch.internal.properties.JobWaitTimeout;
import dev.galasa.zosbatch.internal.properties.TruncateJCLRecords;
import dev.galasa.zosbatch.internal.properties.UseSysaff;
import dev.galasa.zosbatch.internal.properties.ZosBatchPropertiesSingleton;
import dev.galasa.zosbatch.spi.IZosBatchJobOutputSpi;
import dev.galasa.zosconsole.ZosConsoleManagerException;
import dev.galasa.zosconsole.internal.properties.ConsoleRestrictToImage;
import dev.galasa.zosconsole.internal.properties.ZosConsolePropertiesSingleton;
import dev.galasa.zosfile.ZosFileManagerException;
import dev.galasa.zosfile.internal.properties.DirectoryListMaxItems;
import dev.galasa.zosfile.internal.properties.FileRestrictToImage;
import dev.galasa.zosfile.internal.properties.UnixFilePermissions;
import dev.galasa.zosfile.internal.properties.ZosFilePropertiesSingleton;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={IManager.class})
public class ZosManagerImpl
extends AbstractManager
implements IZosManagerSpi {
    protected static final String NAMESPACE = "zos";
    protected static final String ZOSBATCH_NAMESPACE = "zosbatch";
    protected static final String ZOSFILE_NAMESPACE = "zosfile";
    protected static final String ZOSCONSOLE_NAMESPACE = "zosconsole";
    private static final Log logger = LogFactory.getLog(ZosManagerImpl.class);
    private static final String PRIMARY_TAG = "PRIMARY";
    private static final String LOG_SELECTED_FOR_ZOS_TAG = " selected for zosTag '";
    private static final String LOG_ZOS_IMAGE = "zOS Image ";
    private IConfigurationPropertyStoreService cps;
    private IDynamicStatusStoreService dss;
    private IIpNetworkManagerSpi ipManager;
    private ZosPoolPorts zosPoolPorts;
    private final ArrayList<ImageUsage> definedImages = new ArrayList();
    private final HashMap<String, ZosBaseImageImpl> taggedImages = new HashMap();
    private final HashMap<String, String> taggedPorts = new HashMap();
    private final HashMap<String, ZosBaseImageImpl> images = new HashMap();
    private String runid;
    private String javaHome;
    private String zosLibertyInstallDir;
    private String zosConnectInstallDir;

    public List<String> extraBundles(@NotNull IFramework framework) throws ZosManagerException {
        try {
            ZosPropertiesSingleton.setCps(framework.getConfigurationPropertyService(NAMESPACE));
            ZosBatchPropertiesSingleton.setCps(framework.getConfigurationPropertyService(ZOSBATCH_NAMESPACE));
            ZosFilePropertiesSingleton.setCps(framework.getConfigurationPropertyService(ZOSFILE_NAMESPACE));
            ZosConsolePropertiesSingleton.setCps(framework.getConfigurationPropertyService(ZOSCONSOLE_NAMESPACE));
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new ZosManagerException("Unable to request framework services", e);
        }
        ArrayList<String> bundles = new ArrayList<String>();
        bundles.add(BatchExtraBundle.get());
        bundles.add(ConsoleExtraBundle.get());
        bundles.add(FileExtraBundle.get());
        bundles.add(TSOCommandExtraBundle.get());
        bundles.add(UNIXCommandExtraBundle.get());
        return bundles;
    }

    public void initialise(@NotNull IFramework framework, @NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        List ourFields;
        super.initialise(framework, allManagers, activeManagers, galasaTest);
        if (galasaTest.isJava().booleanValue() && !(ourFields = this.findAnnotatedFields(ZosManagerField.class)).isEmpty()) {
            this.youAreRequired(allManagers, activeManagers, galasaTest);
        }
        try {
            this.dss = framework.getDynamicStatusStoreService(NAMESPACE);
            this.cps = framework.getConfigurationPropertyService(NAMESPACE);
        }
        catch (Exception e) {
            throw new ZosManagerException("Unable to request framework services", e);
        }
    }

    public void youAreRequired(@NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        if (activeManagers.contains(this)) {
            return;
        }
        activeManagers.add((IManager)this);
        this.ipManager = (IIpNetworkManagerSpi)this.addDependentManager(allManagers, activeManagers, galasaTest, IIpNetworkManagerSpi.class);
        if (this.ipManager == null) {
            throw new ZosManagerException("The IP Network Manager is not available");
        }
    }

    public void provisionGenerate() throws ManagerException, ResourceUnavailableException {
        List annotatedFields = this.findAnnotatedFields(ZosManagerField.class);
        Set dependencyTags = this.findProvisionDependentAnnotatedFieldTags(ZosImageDependencyField.class, "imageTag");
        boolean primaryFound = false;
        Iterator annotatedFieldIterator = annotatedFields.iterator();
        while (annotatedFieldIterator.hasNext()) {
            ZosImage annotationZosImage;
            String tag;
            AnnotatedField annotatedField = (AnnotatedField)annotatedFieldIterator.next();
            Field field = annotatedField.getField();
            if (field.getType() != IZosImage.class || (tag = (annotationZosImage = field.getAnnotation(ZosImage.class)).imageTag()) != null && !PRIMARY_TAG.equalsIgnoreCase(tag.toUpperCase())) continue;
            IZosImage zosImage = this.generateZosImage(PRIMARY_TAG);
            this.registerAnnotatedField(field, zosImage);
            annotatedFieldIterator.remove();
            primaryFound = true;
            break;
        }
        if (!primaryFound && dependencyTags.contains(PRIMARY_TAG)) {
            this.generateZosImage(PRIMARY_TAG);
            dependencyTags.remove(PRIMARY_TAG);
        }
        for (AnnotatedField annotatedField : annotatedFields) {
            Field field = annotatedField.getField();
            if (this.getAnnotatedField(field) != null || field.getType() != IZosImage.class) continue;
            IZosImage zosImage = this.generateZosImage(field);
            this.registerAnnotatedField(field, zosImage);
        }
        for (String tag : dependencyTags) {
            this.generateZosImage(tag);
        }
        this.zosPoolPorts = new ZosPoolPorts(this, this.getDSS(), this.getFramework().getResourcePoolingService());
        this.generateAnnotatedFields(ZosManagerField.class);
    }

    public void provisionDiscard() {
        for (ZosBaseImageImpl image : this.images.values()) {
            if (!(image instanceof ZosProvisionedImageImpl)) continue;
            ((ZosProvisionedImageImpl)image).freeImage();
        }
    }

    protected IZosImage generateZosImage(Field field) throws ZosManagerException {
        ZosImage annotationZosImage = field.getAnnotation(ZosImage.class);
        String tag = ZosManagerImpl.defaultString((String)annotationZosImage.imageTag(), (String)PRIMARY_TAG).toUpperCase();
        return this.generateZosImage(tag);
    }

    protected IZosImage generateZosImage(String tag) throws ZosManagerException {
        if (this.taggedImages.containsKey(tag)) {
            return this.taggedImages.get(tag);
        }
        logger.info((Object)("Searching for a zos DSE Image configured for tag " + tag));
        String imageID = DseImageIdForTag.get(tag);
        if (imageID != null) {
            logger.info((Object)("zOS DSE Image " + imageID + LOG_SELECTED_FOR_ZOS_TAG + tag + "'"));
            if (this.images.containsKey(imageID)) {
                ZosBaseImageImpl selectedImage = this.images.get(imageID);
                this.taggedImages.put(tag, selectedImage);
                return selectedImage;
            }
            logger.info((Object)("Searching for a zos DSE Cluster configured for tag " + tag));
            String clusterId = DseClusterIdForTag.get(tag);
            ZosDseImageImpl image = new ZosDseImageImpl(this, imageID, clusterId);
            this.images.put(image.getImageID(), image);
            this.taggedImages.put(tag, image);
            return image;
        }
        logger.info((Object)("No DSE Image found, searching for specific zos image for tag " + tag));
        imageID = ImageIdForTag.get(tag);
        if (imageID != null) {
            if (this.images.containsKey(imageID)) {
                ZosBaseImageImpl selectedImage = this.images.get(imageID);
                this.taggedImages.put(tag, selectedImage);
                return selectedImage;
            }
            ZosProvisionedImageImpl image = new ZosProvisionedImageImpl(this, imageID, null);
            if (image.allocateImage()) {
                logger.info((Object)(LOG_ZOS_IMAGE + image.getImageID() + LOG_SELECTED_FOR_ZOS_TAG + tag + "'"));
                this.images.put(image.getImageID(), image);
                this.taggedImages.put(tag, image);
                return image;
            }
            DssUtils.incrementMetric((IDynamicStatusStoreService)this.dss, (String)"metrics.slots.insufficent");
            throw new ZosManagerException("Unable to provision zOS Image tagged " + tag + " on " + imageID + " as there is insufficient capacity");
        }
        logger.info((Object)("No specific image found for tag" + tag + " selecting image"));
        return this.selectNewImage(tag);
    }

    @GenerateAnnotatedField(annotation=ZosIpHost.class)
    public IIpHost generateIpHost(Field field, List<Annotation> annotations) throws ZosManagerException {
        ZosIpHost annotationHost = field.getAnnotation(ZosIpHost.class);
        String tag = ZosManagerImpl.defaultString((String)annotationHost.imageTag(), (String)PRIMARY_TAG).toUpperCase();
        ZosBaseImageImpl image = this.taggedImages.get(tag);
        if (image == null) {
            throw new ZosManagerException("Unable to provision an IP Host for field " + field.getName() + " as no @ZosImage for the tag '" + tag + "' was present");
        }
        return image.getIpHost();
    }

    @GenerateAnnotatedField(annotation=ZosIpPort.class)
    public IIpPort generateIpPort(Field field, List<Annotation> annotations) throws ZosManagerException {
        ZosIpPort annotationPort = field.getAnnotation(ZosIpPort.class);
        String imageTag = ZosManagerImpl.defaultString((String)annotationPort.imageTag(), (String)PRIMARY_TAG).toUpperCase();
        String type = ZosManagerImpl.defaultString((String)annotationPort.type(), (String)"standard");
        String tag = annotationPort.tag();
        ZosBaseImageImpl image = this.taggedImages.get(imageTag);
        if (image == null) {
            throw new ZosManagerException("Unable to provision an IP Host for field " + field.getName() + " as no @ZosImage for the tag '" + imageTag + "' was present");
        }
        try {
            IIpPort provisionedPort = image.getIpHost().provisionPort(type);
            if (!tag.isEmpty()) {
                this.taggedPorts.put(tag, "" + provisionedPort.getPortNumber());
            }
            return provisionedPort;
        }
        catch (Exception e) {
            throw new ZosManagerException("Unable to provision a port for zOS Image " + image.getImageID() + ", type=" + type, e);
        }
    }

    protected ZosProvisionedImageImpl selectNewImage(String tag) throws ZosManagerException {
        logger.info((Object)("Searching for cluster ID for tag " + tag));
        String clusterId = ClusterIdForTag.get(tag);
        if (clusterId == null) {
            logger.info((Object)("No cluster ID found for tag " + tag + " assuming DEFAULT"));
            clusterId = "DEFAULT";
        }
        clusterId = clusterId.toUpperCase();
        logger.info((Object)("Searching for list of images for cluster " + clusterId));
        for (String definedImage : ClusterImages.get(clusterId)) {
            ZosProvisionedImageImpl image = new ZosProvisionedImageImpl(this, definedImage, clusterId);
            this.definedImages.add(new ImageUsage(image));
        }
        Collections.sort(this.definedImages);
        for (ImageUsage image : this.definedImages) {
            if (this.images.containsKey(image.image.getImageID()) || !image.image.allocateImage()) continue;
            logger.info((Object)(LOG_ZOS_IMAGE + image.image.getImageID() + LOG_SELECTED_FOR_ZOS_TAG + tag + "' with slot name " + image.image.getSlotName()));
            this.taggedImages.put(tag, image.image);
            this.images.put(image.image.getImageID(), image.image);
            return image.image;
        }
        DssUtils.incrementMetric((IDynamicStatusStoreService)this.dss, (String)"metrics.slots.insufficent");
        throw new ZosManagerException("Insufficent capacity for images in cluster " + clusterId);
    }

    protected IDynamicStatusStoreService getDSS() {
        return this.dss;
    }

    public IConfigurationPropertyStoreService getCPS() {
        return this.cps;
    }

    protected IIpNetworkManagerSpi getIpManager() {
        return this.ipManager;
    }

    @Override
    @NotNull
    public IZosImage provisionImageForTag(String tag) throws ZosManagerException {
        Objects.nonNull(tag);
        tag = tag.toUpperCase();
        IZosImage image = this.taggedImages.get(tag);
        if (image == null) {
            return this.generateZosImage(tag);
        }
        return image;
    }

    @Override
    @NotNull
    public IZosImage getImageForTag(String tag) throws ZosManagerException {
        Objects.nonNull(tag);
        tag = tag.toUpperCase();
        IZosImage image = this.taggedImages.get(tag);
        if (image == null) {
            throw new ZosManagerException("Unable to locate zOS Image for tag " + tag);
        }
        return image;
    }

    @Override
    public IZosImage getImage(String imageId) throws ZosManagerException {
        Objects.nonNull(imageId);
        IZosImage zosImage = this.images.get(imageId);
        if (zosImage == null) {
            for (ImageUsage imageUsage : this.definedImages) {
                if (this.images.containsKey(imageUsage.image.getImageID()) || !imageUsage.image.getImageID().equals(imageId) || !imageUsage.image.allocateImage()) continue;
                logger.info((Object)(LOG_ZOS_IMAGE + imageUsage.image.getImageID() + " selected with slot name " + imageUsage.image.getSlotName()));
                this.images.put(imageUsage.image.getImageID(), imageUsage.image);
                return imageUsage.image;
            }
        } else if (zosImage instanceof ZosProvisionedImageImpl) {
            logger.info((Object)(LOG_ZOS_IMAGE + zosImage.getImageID() + " selected with slot name " + ((ZosProvisionedImageImpl)zosImage).getSlotName()));
        } else {
            logger.info((Object)(LOG_ZOS_IMAGE + zosImage.getImageID() + " selected"));
        }
        if (zosImage == null) {
            throw new ZosManagerException("zOS image \"" + imageId + "\" not defined");
        }
        return zosImage;
    }

    @Override
    public ICredentials getCredentials(String credentialsId, String imageId) throws ZosManagerException {
        ICredentials credentials;
        try {
            ICredentialsService credsService = this.getFramework().getCredentialsService();
            credentials = credsService.getCredentials(credentialsId);
            if (credentials == null) {
                credentials = credsService.getCredentials(credentialsId.toUpperCase());
            }
        }
        catch (CredentialsException e) {
            throw new ZosManagerException("Unable to acquire the credentials for id " + credentialsId, e);
        }
        if (credentials == null) {
            throw new ZosManagerException("zOS Credentials missing for image " + imageId + " id " + credentialsId);
        }
        return credentials;
    }

    @Override
    public IZosImage getUnmanagedImage(String imageId) throws ZosManagerException {
        Objects.nonNull(imageId);
        IZosImage zosImage = this.images.get(imageId);
        if (zosImage != null) {
            return zosImage;
        }
        String clusterId = DseClusterIdForTag.get(imageId);
        ZosDseImageImpl image = new ZosDseImageImpl(this, imageId, clusterId);
        this.images.put(image.getImageID(), image);
        return image;
    }

    @Override
    public String getRunDatasetHLQ(IZosImage image) throws ZosManagerException {
        Objects.nonNull(image);
        return RunDatasetHLQ.get(image);
    }

    @Override
    public String getRunUNIXPathPrefix(IZosImage image) throws ZosManagerException {
        Objects.nonNull(image);
        return RunUNIXPathPrefix.get(image);
    }

    @Override
    public boolean getZosBatchPropertyBatchRestrictToImage(String imageId) throws ZosBatchManagerException {
        return BatchRestrictToImage.get(imageId);
    }

    @Override
    public boolean getZosBatchPropertyUseSysaff(String imageId) throws ZosBatchManagerException {
        return UseSysaff.get(imageId);
    }

    @Override
    public int getZosBatchPropertyJobWaitTimeout(String imageId) throws ZosBatchManagerException {
        return JobWaitTimeout.get(imageId);
    }

    @Override
    public boolean getZosBatchPropertyTruncateJCLRecords(String imageId) throws ZosBatchManagerException {
        return TruncateJCLRecords.get(imageId);
    }

    @Override
    public IZosBatchJobname newZosBatchJobname(IZosImage image) throws ZosBatchException {
        return new ZosBatchJobnameImpl(image);
    }

    @Override
    public IZosBatchJobname newZosBatchJobname(String name) {
        return new ZosBatchJobnameImpl(name);
    }

    @Override
    public IZosBatchJobOutputSpi newZosBatchJobOutput(IZosBatchJob batchJob, String jobname, String jobid) {
        return new ZosBatchJobOutputImpl(batchJob, jobname, jobid);
    }

    @Override
    public IZosBatchJobOutputSpoolFile newZosBatchJobOutputSpoolFile(IZosBatchJob batchJob, String jobname, String jobid, String stepname, String procstep, String ddname, String id, String records) throws ZosBatchException {
        return new ZosBatchJobOutputSpoolFileImpl(batchJob, jobname, jobid, stepname, procstep, ddname, id, records);
    }

    @Override
    public int getZosFilePropertyDirectoryListMaxItems(String imageId) throws ZosFileManagerException {
        return DirectoryListMaxItems.get(imageId);
    }

    @Override
    public boolean getZosFilePropertyFileRestrictToImage(String imageId) throws ZosFileManagerException {
        return FileRestrictToImage.get(imageId);
    }

    @Override
    public String getZosFilePropertyUnixFilePermissions(String imageId) throws ZosFileManagerException {
        return UnixFilePermissions.get(imageId);
    }

    @Override
    public boolean getZosConsolePropertyConsoleRestrictToImage(String imageId) throws ZosConsoleManagerException {
        return ConsoleRestrictToImage.get(imageId);
    }

    @Override
    public String buildUniquePathName(Path artifactPath, String name) {
        int uniqueId = 1;
        while (Files.exists(artifactPath.resolve(name), new LinkOption[0])) {
            Pattern pattern = Pattern.compile("[_][\\d]+$");
            Matcher matcher = pattern.matcher(name);
            if (matcher.find()) {
                name = matcher.replaceFirst("_" + Integer.toString(uniqueId));
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(name);
                stringBuilder.append("_");
                stringBuilder.append(uniqueId);
                name = stringBuilder.toString();
            }
            ++uniqueId;
        }
        return name;
    }

    @Override
    public void storeArtifact(Path artifactPath, String content, ResultArchiveStoreContentType type) throws ZosManagerException {
        try {
            if (content == null) {
                content = "";
            }
            Files.createFile(artifactPath, new FileAttribute[]{type});
            Files.write(artifactPath, content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ZosManagerException("Unable to store artifact", e);
        }
    }

    @Override
    public void createArtifactDirectory(Path artifactPath) throws ZosManagerException {
        try {
            Files.createDirectories(artifactPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ZosManagerException("Unable to create artifact directory", e);
        }
    }

    public String getRunId() {
        if (this.runid == null) {
            this.runid = this.getFramework().getTestRunName();
        }
        return this.runid;
    }

    public String getJavaHome(ZosBaseImageImpl image) throws ZosManagerException {
        if (this.javaHome == null) {
            this.javaHome = JavaHome.get(image);
        }
        return this.javaHome;
    }

    public String getLibertyInstallDir(ZosBaseImageImpl image) throws ZosManagerException {
        if (this.zosLibertyInstallDir == null) {
            this.zosLibertyInstallDir = LibertyInstallDir.get(image);
        }
        return this.zosLibertyInstallDir;
    }

    public String getZosConnectInstallDir(ZosBaseImageImpl image) throws ZosManagerException {
        if (this.zosConnectInstallDir == null) {
            this.zosConnectInstallDir = ZosConnectInstallDir.get(image);
        }
        return this.zosConnectInstallDir;
    }

    public ZosPoolPorts getZosPortController() {
        return this.zosPoolPorts;
    }

    @Override
    public HashMap<String, String> getTaggedPorts() {
        return this.taggedPorts;
    }

    protected static class ImageUsage
    implements Comparable<ImageUsage> {
        private final ZosProvisionedImageImpl image;
        private Float usage;

        public ImageUsage(ZosProvisionedImageImpl image) throws ZosManagerException {
            this.image = image;
            this.usage = image.getCurrentUsage();
        }

        @Override
        public int compareTo(ImageUsage o) {
            return this.usage.compareTo(o.usage);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((ImageUsage)obj) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.image);
        }

        public String toString() {
            return this.image.getImageID();
        }
    }
}

