/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos.internal;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DssDelete;
import dev.galasa.framework.spi.DssUpdate;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreMatchException;
import dev.galasa.framework.spi.IDssAction;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IResourcePoolingService;
import dev.galasa.framework.spi.InsufficientResourcesAvailableException;
import dev.galasa.zos.ZosManagerException;
import dev.galasa.zos.internal.ZosManagerImpl;
import dev.galasa.zos.internal.properties.PoolPorts;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZosPoolPorts {
    private static final Log logger = LogFactory.getLog(ZosPoolPorts.class);
    private final ZosManagerImpl manager;
    private final IDynamicStatusStoreService dss;
    private final IResourcePoolingService rps;

    public ZosPoolPorts(ZosManagerImpl manager, IDynamicStatusStoreService dss, IResourcePoolingService rps) throws ZosManagerException {
        this.manager = manager;
        this.dss = dss;
        this.rps = rps;
    }

    public String allocatePort(String image) throws ZosManagerException, ConfigurationPropertyStoreException {
        List<String> resourceStrings = PoolPorts.get(image);
        List zosPorts = null;
        String thePort = null;
        try {
            zosPorts = this.rps.obtainResources(resourceStrings, null, 1, 1, this.dss, "zosport." + image);
        }
        catch (InsufficientResourcesAvailableException exception) {
            throw new ZosManagerException("Could not obtain a port from the z/OS port pool for image " + image);
        }
        try {
            thePort = (String)zosPorts.get(0);
            this.dss.performActions(new IDssAction[]{new DssUpdate("zosport." + image + "." + thePort, this.manager.getFramework().getTestRunName()), new DssUpdate("run." + this.manager.getFramework().getTestRunName() + ".zosport." + image + "." + thePort, "active")});
            logger.trace((Object)("Allocated z/OS port " + thePort + " on image " + image + " from z/OS port pool allocation"));
        }
        catch (DynamicStatusStoreException exception) {
            throw new ZosManagerException("Could not update the DSS for port allocation of z/OS port " + thePort + " on image " + image);
        }
        return thePort;
    }

    public static void deleteDss(String port, String image, String run, IDynamicStatusStoreService dss) throws DynamicStatusStoreMatchException, DynamicStatusStoreException {
        dss.performActions(new IDssAction[]{new DssDelete("zosport." + image + "." + port, run), new DssDelete("run." + run + ".zosport." + image + "." + port, "active")});
    }
}

