/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos.internal;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResourceManagement;
import dev.galasa.zos.internal.ZosPoolPorts;
import dev.galasa.zos.internal.ZosResourceManagement;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZosPortResourceMonitor
implements Runnable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final IFramework framework;
    private final IResourceManagement resourceManagement;
    private final IDynamicStatusStoreService dss;

    public ZosPortResourceMonitor(IFramework framework, IResourceManagement resourceManagement, IDynamicStatusStoreService dss, ZosResourceManagement zosResourceManagement, IConfigurationPropertyStoreService cps) {
        this.framework = framework;
        this.resourceManagement = resourceManagement;
        this.dss = dss;
        this.logger.info((Object)"zOS port provisioning resource monitor initialised");
    }

    @Override
    public void run() {
        this.logger.info((Object)"Monitoring for z/OS ports held up in allocated status");
        try {
            Map zosPortsInDss = this.dss.getPrefix("zosport");
            Set allActiveRuns = this.framework.getFrameworkRuns().getActiveRunNames();
            for (String key : zosPortsInDss.keySet()) {
                if (allActiveRuns.contains(zosPortsInDss.get(key))) continue;
                String removeRun = (String)zosPortsInDss.get(key);
                String removeImage = key.split("\\.")[1];
                String removePort = key.split("\\.")[2];
                this.logger.info((Object)("Freeing allocated port " + removePort + " assigned to inactive run " + removeRun));
                this.deleteDss(removePort, removeImage, removeRun);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failure during scanning DSS for z/OS ports");
        }
        this.resourceManagement.resourceManagementRunSuccessful();
        this.logger.info((Object)"Finished cleaning up z/OS port allocation");
    }

    public void runFinishedOrDeleted(String runName) {
        try {
            Map zosPortsInDss = this.dss.getPrefix("zosport");
            for (String key : zosPortsInDss.keySet()) {
                if (!((String)zosPortsInDss.get(key)).equals(runName)) continue;
                this.deleteDss(key.split("\\.")[2], key.split("\\.")[1], (String)zosPortsInDss.get(key));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failure cleaning up z/OS ports for finished run " + runName));
        }
    }

    private void deleteDss(String port, String image, String run) {
        this.logger.info((Object)("Freeing port " + port + " on image " + image + " allocated to run " + run + " which has finished"));
        try {
            ZosPoolPorts.deleteDss(port, image, run, this.dss);
        }
        catch (Exception e) {
            this.logger.error((Object)("Failure in discarding z/OS port " + port + " on image " + image + " allocated to run " + run));
        }
    }
}

