/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos.internal;

import dev.galasa.framework.spi.IDynamicResource;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.zos.ZosManagerException;
import dev.galasa.zos.internal.ZosBaseImageImpl;
import dev.galasa.zos.internal.ZosManagerImpl;
import dev.galasa.zos.internal.properties.ImageMaxSlots;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZosProvisionedImageImpl
extends ZosBaseImageImpl {
    private static final Log logger = LogFactory.getLog(ZosProvisionedImageImpl.class);
    private final IDynamicStatusStoreService dss;
    private final IDynamicResource dynamicResource;
    private String allocatedSlotName;

    public ZosProvisionedImageImpl(ZosManagerImpl zosManager, String imageId, String clusterId) throws ZosManagerException {
        super(zosManager, imageId, clusterId);
        this.dss = zosManager.getDSS();
        this.dynamicResource = this.dss.getDynamicResource("image." + this.getImageID());
    }

    public boolean hasCapacity() throws ZosManagerException {
        return this.getCurrentUsage().floatValue() < 1.0f;
    }

    public Float getCurrentUsage() throws ZosManagerException {
        IDynamicStatusStoreService dss = this.getZosManager().getDSS();
        float maxSlots = ImageMaxSlots.get(this.getImageID());
        if (maxSlots <= 0.0f) {
            return Float.valueOf(1.0f);
        }
        float usedSlots = 0.0f;
        try {
            String currentSlots = dss.get("image." + this.getImageID() + ".current.slots");
            if (currentSlots != null) {
                usedSlots = Integer.parseInt(currentSlots);
            }
        }
        catch (Exception e) {
            throw new ZosManagerException("Problem finding used slots for zOS Image " + this.getImageID(), e);
        }
        return Float.valueOf(usedSlots / maxSlots);
    }

    public boolean allocateImage() throws ZosManagerException {
        String runName = this.getZosManager().getFramework().getTestRunName();
        int maxSlots = ImageMaxSlots.get(this.getImageID());
        try {
            int usedSlots = 0;
            String currentSlots = this.dss.get("image." + this.getImageID() + ".current.slots");
            if (currentSlots != null) {
                usedSlots = Integer.parseInt(currentSlots);
            }
            if (usedSlots >= maxSlots) {
                return false;
            }
            if (!this.dss.putSwap("image." + this.getImageID() + ".current.slots", currentSlots, Integer.toString(++usedSlots))) {
                Thread.sleep(200L);
                return this.allocateImage();
            }
            String slotName = "SLOT_" + runName;
            int i = 0;
            while (true) {
                String actualSlotname = slotName;
                if (i > 0) {
                    actualSlotname = actualSlotname + "_" + i;
                }
                String allocated = Instant.now().toString();
                String prefix = "image." + this.getImageID() + ".slot." + actualSlotname;
                HashMap<CallSite, String> otherProps = new HashMap<CallSite, String>();
                otherProps.put((CallSite)((Object)("slot.run." + runName + "." + prefix)), "active");
                if (this.dss.putSwap(prefix, null, runName, otherProps)) {
                    this.allocatedSlotName = actualSlotname;
                    String resPrefix = "slot." + this.allocatedSlotName;
                    HashMap<CallSite, String> resProps = new HashMap<CallSite, String>();
                    resProps.put((CallSite)((Object)(resPrefix + ".run")), runName);
                    resProps.put((CallSite)((Object)(resPrefix + ".allocated")), allocated);
                    this.dynamicResource.put(resProps);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ZosManagerException("Problem finding used slots for zOS Image " + this.getImageID(), e);
        }
        return true;
    }

    public String getSlotName() {
        return this.allocatedSlotName;
    }

    public void freeImage() {
        try {
            String currentSlots = this.dss.get("image." + this.getImageID() + ".current.slots");
            if (currentSlots == null) {
                return;
            }
            int usedSlots = Integer.parseInt(currentSlots);
            if (--usedSlots < 0) {
                usedSlots = 0;
            }
            String runName = this.getZosManager().getFramework().getTestRunName();
            String resPrefix = "slot." + this.allocatedSlotName;
            HashSet<CallSite> resProps = new HashSet<CallSite>();
            resProps.add((CallSite)((Object)(resPrefix + ".run")));
            resProps.add((CallSite)((Object)(resPrefix + ".allocated")));
            this.dynamicResource.delete(resProps);
            String prefix = "image." + this.getImageID() + ".slot." + this.allocatedSlotName;
            HashMap<CallSite, String> otherProps = new HashMap<CallSite, String>();
            otherProps.put((CallSite)((Object)("slot.run." + this.getZosManager().getFramework().getTestRunName() + "." + prefix)), "free");
            if (!this.dss.putSwap("image." + this.getImageID() + ".current.slots", currentSlots, Integer.toString(usedSlots), otherProps)) {
                Thread.sleep(200L);
                this.freeImage();
                return;
            }
            HashSet<CallSite> delProps = new HashSet<CallSite>();
            delProps.add((CallSite)((Object)("slot.run." + runName + "." + prefix)));
            delProps.add((CallSite)((Object)prefix));
            this.dss.delete(delProps);
            this.dss.delete("image." + this.getImageID() + ".current.slot." + this.allocatedSlotName);
            logger.info((Object)("Discard slot name " + this.allocatedSlotName + " for zOS Image " + this.getImageID()));
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to free slot on image " + this.getImageID() + ", slot " + this.allocatedSlotName + ", leaving for manager clean up routines"), (Throwable)e);
        }
    }

    public static void deleteDss(String runName, String imageId, String slot, IDynamicStatusStoreService dss) {
        try {
            IDynamicResource dynamicResource = dss.getDynamicResource("image." + imageId);
            String resPrefix = "slot." + slot;
            HashSet<CallSite> resProps = new HashSet<CallSite>();
            resProps.add((CallSite)((Object)(resPrefix + ".run")));
            resProps.add((CallSite)((Object)(resPrefix + ".allocated")));
            dynamicResource.delete(resProps);
            String prefix = "image." + imageId + ".slot." + slot;
            String runSlot = dss.get("slot.run." + runName + "." + prefix);
            if ("active".equals(runSlot) && dss.putSwap("slot.run." + runName + "." + prefix, "active", "free")) {
                while (true) {
                    String sCurrentSlots = dss.get("image." + imageId + ".current.slots");
                    int currentSlots = Integer.parseInt(sCurrentSlots);
                    if (--currentSlots < 0) {
                        currentSlots = 0;
                    }
                    if (dss.putSwap("image." + imageId + ".current.slots", sCurrentSlots, Integer.toString(currentSlots))) break;
                    Thread.sleep(100L);
                }
            }
            HashSet<CallSite> props = new HashSet<CallSite>();
            props.add((CallSite)((Object)prefix));
            props.add((CallSite)((Object)("slot.run." + runName + "." + prefix)));
            dss.delete(props);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to discard slot " + slot + " on image " + imageId), (Throwable)e);
        }
    }
}

