/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos.internal;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResourceManagement;
import dev.galasa.framework.spi.IResourceManagementProvider;
import dev.galasa.framework.spi.ResourceManagerException;
import dev.galasa.zos.internal.SlotResourceMonitor;
import dev.galasa.zos.internal.ZosPortResourceMonitor;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;

@Component(service={IResourceManagementProvider.class})
public class ZosResourceManagement
implements IResourceManagementProvider {
    private IFramework framework;
    private IResourceManagement resourceManagement;
    private IDynamicStatusStoreService dss;
    private IConfigurationPropertyStoreService cps;
    private SlotResourceMonitor slotResourceMonitor;
    private ZosPortResourceMonitor zosPortResourceMonitor;

    public boolean initialise(IFramework framework, IResourceManagement resourceManagement) throws ResourceManagerException {
        this.framework = framework;
        this.resourceManagement = resourceManagement;
        try {
            this.dss = this.framework.getDynamicStatusStoreService("zos");
            this.cps = this.framework.getConfigurationPropertyService("zos");
        }
        catch (Exception e) {
            throw new ResourceManagerException("Unable to initialise zOS resource monitor", (Throwable)e);
        }
        this.slotResourceMonitor = new SlotResourceMonitor(framework, resourceManagement, this.dss, this, this.cps);
        this.zosPortResourceMonitor = new ZosPortResourceMonitor(framework, resourceManagement, this.dss, this, this.cps);
        return true;
    }

    public void start() {
        this.resourceManagement.getScheduledExecutorService().scheduleWithFixedDelay(this.slotResourceMonitor, this.framework.getRandom().nextInt(20), 20L, TimeUnit.SECONDS);
        this.resourceManagement.getScheduledExecutorService().scheduleWithFixedDelay(this.zosPortResourceMonitor, this.framework.getRandom().nextInt(20), 20L, TimeUnit.SECONDS);
    }

    public void shutdown() {
    }

    public void runFinishedOrDeleted(String runName) {
        this.slotResourceMonitor.runFinishedOrDeleted(runName);
        this.zosPortResourceMonitor.runFinishedOrDeleted(runName);
    }
}

