/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos.internal.metrics;

import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IMetricsProvider;
import dev.galasa.framework.spi.IMetricsServer;
import dev.galasa.framework.spi.MetricsServerException;
import io.prometheus.client.Gauge;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={IMetricsProvider.class})
public class ZosMetrics
implements IMetricsProvider,
Runnable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private IFramework framework;
    private IMetricsServer metricsServer;
    private IDynamicStatusStoreService dss;
    private Gauge noSlots;

    public boolean initialise(IFramework framework, IMetricsServer metricsServer) throws MetricsServerException {
        this.framework = framework;
        this.metricsServer = metricsServer;
        try {
            this.dss = this.framework.getDynamicStatusStoreService("zos");
        }
        catch (Exception e) {
            throw new MetricsServerException("Unable to initialise zOS Metrics", (Throwable)e);
        }
        this.noSlots = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("galasa_zos_insufficent_slots_total")).help("How many times insufficent slots has occurred")).register();
        return true;
    }

    public void start() {
        this.metricsServer.getScheduledExecutorService().scheduleWithFixedDelay(this, 1L, 10L, TimeUnit.SECONDS);
    }

    public void shutdown() {
    }

    @Override
    public void run() {
        this.logger.info((Object)"zOS Poll");
        try {
            String sNoSlots = AbstractManager.nulled((String)this.dss.get("metrics.slots.insufficent"));
            if (sNoSlots == null) {
                this.noSlots.set(0.0);
            } else {
                this.noSlots.set(Double.parseDouble(sNoSlots));
            }
            this.metricsServer.metricsPollSuccessful();
        }
        catch (Exception e) {
            this.logger.error((Object)"Problem with zOS poll", (Throwable)e);
        }
    }
}

