/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos.internal.properties;

import dev.galasa.ICredentials;
import dev.galasa.ICredentialsUsernamePassword;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.cps.CpsProperties;
import dev.galasa.zos.IZosImage;
import dev.galasa.zos.ZosManagerException;
import dev.galasa.zos.internal.properties.ZosPropertiesSingleton;
import javax.validation.constraints.NotNull;

public class RunDatasetHLQ
extends CpsProperties {
    public static String get(@NotNull IZosImage image) throws ZosManagerException {
        String imageId = image.getImageID();
        try {
            String runDatasetHLQ = RunDatasetHLQ.getStringNulled((IConfigurationPropertyStoreService)ZosPropertiesSingleton.cps(), (String)("run." + imageId), (String)"dataset.hlq", (String[])new String[0]);
            if (runDatasetHLQ == null) {
                ICredentials creds = image.getDefaultCredentials();
                if (!(creds instanceof ICredentialsUsernamePassword)) {
                    throw new ZosManagerException("Unable to get the run username for image " + imageId);
                }
                return ((ICredentialsUsernamePassword)creds).getUsername() + ".GALASA".toUpperCase();
            }
            return runDatasetHLQ.toUpperCase();
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new ZosManagerException("Problem asking the CPS for the zOS run data set HLQ for image " + imageId, e);
        }
    }
}

