/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos.internal.properties;

import dev.galasa.ICredentials;
import dev.galasa.ICredentialsUsernamePassword;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.cps.CpsProperties;
import dev.galasa.zos.IZosImage;
import dev.galasa.zos.ZosManagerException;
import dev.galasa.zos.internal.properties.ZosPropertiesSingleton;
import javax.validation.constraints.NotNull;

public class RunUNIXPathPrefix
extends CpsProperties {
    public static String get(@NotNull IZosImage image) throws ZosManagerException {
        String imageId = image.getImageID();
        try {
            String runUNIXPathePrefix = RunUNIXPathPrefix.getStringNulled((IConfigurationPropertyStoreService)ZosPropertiesSingleton.cps(), (String)"run", (String)"unix.path.prefix", (String[])new String[]{imageId});
            if (runUNIXPathePrefix == null) {
                ICredentials creds = image.getDefaultCredentials();
                if (!(creds instanceof ICredentialsUsernamePassword)) {
                    throw new ZosManagerException("Unable to get the run username for image " + imageId);
                }
                return "/u/" + ((ICredentialsUsernamePassword)creds).getUsername().toLowerCase() + "/Galasa";
            }
            return runUNIXPathePrefix;
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new ZosManagerException("Problem asking the CPS for the zOS run UNIX path prefix for image " + imageId, e);
        }
    }
}

