/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosbatch;

import dev.galasa.zosbatch.IZosBatchJobOutput;
import dev.galasa.zosbatch.IZosBatchJobOutputSpoolFile;
import dev.galasa.zosbatch.IZosBatchJobname;
import dev.galasa.zosbatch.ZosBatchException;

public interface IZosBatchJob {
    public IZosBatchJobname getJobname();

    public String getJobId();

    public String getOwner();

    public String getType();

    public JobStatus getStatus();

    public String getStatusString();

    public String getRetcode();

    public int waitForJob() throws ZosBatchException;

    public int waitForJob(long var1) throws ZosBatchException;

    public IZosBatchJobOutput listSpoolFiles() throws ZosBatchException;

    public IZosBatchJobOutput retrieveOutput() throws ZosBatchException;

    public String retrieveOutputAsString() throws ZosBatchException;

    public IZosBatchJobOutputSpoolFile getSpoolFile(String var1) throws ZosBatchException;

    public void cancel() throws ZosBatchException;

    public void purge() throws ZosBatchException;

    public void saveOutputToResultsArchive(String var1) throws ZosBatchException;

    public void setShouldArchive(boolean var1);

    public boolean shouldArchive();

    public void setShouldCleanup(boolean var1);

    public boolean shouldCleanup();

    public void saveSpoolFileToResultsArchive(IZosBatchJobOutputSpoolFile var1, String var2) throws ZosBatchException;

    public static enum JobStatus {
        INPUT("INPUT"),
        ACTIVE("ACTIVE"),
        OUTPUT("OUTPUT"),
        NOTFOUND("NOTFOUND"),
        UNKNOWN("UNKNOWN");

        private String value;

        private JobStatus(String value) {
            this.value = value;
        }

        public static JobStatus valueOfLabel(String jobStatus) {
            for (JobStatus element : JobStatus.values()) {
                if (!element.value.equals(jobStatus)) continue;
                return element;
            }
            return UNKNOWN;
        }
    }
}

