/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosbatch;

import dev.galasa.zos.IZosImage;
import dev.galasa.zosbatch.ZosBatchManagerException;
import dev.galasa.zosbatch.internal.properties.InputClass;
import dev.galasa.zosbatch.internal.properties.MsgClass;
import dev.galasa.zosbatch.internal.properties.MsgLevel;

public class ZosBatchJobcard {
    private String inputClass;
    private String msgClass;
    private String msgLevel;
    private String region;
    private String memlimit;
    private Typrun typrun;
    private String user;
    private String password;
    private String cond;
    private String time;
    private String account;
    private String progname;

    public ZosBatchJobcard setInputClass(String inputClass) {
        this.inputClass = inputClass;
        return this;
    }

    public ZosBatchJobcard setMsgClass(String msgClass) {
        this.msgClass = msgClass;
        return this;
    }

    public ZosBatchJobcard setMsgLevel(String msgLevel) {
        this.msgLevel = msgLevel;
        return this;
    }

    public ZosBatchJobcard setRegion(String region) {
        this.region = region;
        return this;
    }

    public ZosBatchJobcard setMemlimit(String memlimit) {
        this.memlimit = memlimit;
        return this;
    }

    public ZosBatchJobcard setTyprun(Typrun typrun) {
        this.typrun = typrun;
        return this;
    }

    public ZosBatchJobcard setUser(String user) {
        this.user = user;
        return this;
    }

    public ZosBatchJobcard setPassword(String password) {
        this.password = password;
        return this;
    }

    public ZosBatchJobcard setCond(String cond) {
        this.cond = cond;
        return this;
    }

    public ZosBatchJobcard setTime(String time) {
        this.time = time;
        return this;
    }

    public ZosBatchJobcard setAccount(String account) {
        this.account = account;
        return this;
    }

    public ZosBatchJobcard setProgrammerName(String progname) {
        this.progname = progname;
        return this;
    }

    public String getInputClass() {
        return this.nulled(this.inputClass);
    }

    public String getMsgClass() {
        return this.nulled(this.msgClass);
    }

    public String getMsgLevel() {
        return this.nulled(this.msgLevel);
    }

    public String getRegion() {
        return this.nulled(this.region);
    }

    public String getMemlimit() {
        return this.nulled(this.memlimit);
    }

    public Typrun getTyprun() {
        return this.typrun;
    }

    public String getUser() {
        return this.nulled(this.user);
    }

    public String getPassword() {
        return this.nulled(this.password);
    }

    public String getCond() {
        return this.nulled(this.cond);
    }

    public String getTime() {
        return this.nulled(this.time);
    }

    public String getAccount() {
        return this.nulled(this.account);
    }

    public String getProgrammerName() {
        return this.nulled(this.progname);
    }

    public String getJobcard(String jobname, IZosImage image) throws ZosBatchManagerException {
        StringBuilder jobCard = new StringBuilder();
        jobCard.append("//");
        jobCard.append(jobname);
        jobCard.append(" JOB ");
        String acct = this.getAccount();
        String prog = this.getProgrammerName();
        if (acct != null || prog != null) {
            if (acct != null) {
                if (!acct.startsWith("(")) {
                    jobCard.append("(");
                }
                jobCard.append(acct);
                if (!acct.endsWith(")")) {
                    jobCard.append(")");
                }
            }
            if (prog != null) {
                jobCard.append(",");
                jobCard.append("'");
                jobCard.append(prog);
                jobCard.append("'");
            }
        }
        jobCard.append(",\n");
        if (this.inputClass == null) {
            this.inputClass = InputClass.get(image);
        }
        if (this.msgClass == null) {
            this.msgClass = MsgClass.get(image);
        }
        if (this.msgLevel == null) {
            this.msgLevel = MsgLevel.get(image);
        }
        if (this.region != null) {
            jobCard.append("//         REGION=");
            jobCard.append(this.region);
            jobCard.append(",\n");
        }
        if (this.memlimit != null) {
            jobCard.append("//         MEMLIMIT=");
            jobCard.append(this.memlimit);
            jobCard.append(",\n");
        }
        if (this.typrun != null) {
            jobCard.append("//         TYPRUN=");
            jobCard.append(this.typrun.toString());
            jobCard.append(",\n");
        }
        if (this.user != null) {
            jobCard.append("//         USER=");
            jobCard.append(this.user);
            jobCard.append(",\n");
        }
        if (this.password != null) {
            jobCard.append("//         PASSWORD=");
            jobCard.append(this.password);
            jobCard.append(",\n");
        }
        if (this.cond != null) {
            jobCard.append("//         COND=");
            jobCard.append(this.cond);
            jobCard.append(",\n");
        }
        if (this.time != null) {
            jobCard.append("//         TIME=");
            jobCard.append(this.time);
            jobCard.append(",\n");
        }
        jobCard.append("//         CLASS=");
        jobCard.append(this.inputClass);
        jobCard.append(",\n");
        jobCard.append("//         MSGCLASS=");
        jobCard.append(this.msgClass);
        jobCard.append(",\n");
        jobCard.append("//         MSGLEVEL=");
        jobCard.append(this.msgLevel);
        jobCard.append("\n");
        return jobCard.toString();
    }

    protected String nulled(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        return value;
    }

    public static enum Typrun {
        COPY,
        HOLD,
        JCLHOLD,
        SCAN;

    }
}

