/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosbatch.internal;

import dev.galasa.zosbatch.IZosBatchJob;
import dev.galasa.zosbatch.IZosBatchJobOutputSpoolFile;
import dev.galasa.zosbatch.ZosBatchException;
import dev.galasa.zosbatch.internal.ZosBatchJobOutputSpoolFileImpl;
import dev.galasa.zosbatch.spi.IZosBatchJobOutputSpi;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ZosBatchJobOutputImpl
implements IZosBatchJobOutputSpi {
    private IZosBatchJob batchJob;
    private String jobname;
    private String jobid;
    private ArrayList<IZosBatchJobOutputSpoolFile> spoolFiles = new ArrayList();

    public ZosBatchJobOutputImpl(IZosBatchJob batchJob, String jobname, String jobid) {
        this.batchJob = batchJob;
        this.jobname = jobname;
        this.jobid = jobid;
    }

    @Override
    public void addJcl(String jcl) {
        this.spoolFiles.add(new ZosBatchJobOutputSpoolFileImpl(this.batchJob, this.jobname, this.jobid, "", "", "JESJCLIN", "JCL", jcl));
    }

    @Override
    public void addSpoolFile(String stepname, String procstep, String ddname, String id, String records) {
        for (IZosBatchJobOutputSpoolFile spool : this.spoolFiles) {
            if (!ddname.equals(spool.getDdname()) || stepname == null || !stepname.equals(spool.getStepname())) continue;
            spool.setRecords(records);
            return;
        }
        this.spoolFiles.add(new ZosBatchJobOutputSpoolFileImpl(this.batchJob, this.jobname, this.jobid, Objects.toString(stepname, ""), Objects.toString(procstep, ""), ddname, id, records));
    }

    @Override
    public String getJobname() throws ZosBatchException {
        return this.jobname;
    }

    @Override
    public String getJobid() throws ZosBatchException {
        return this.jobid;
    }

    @Override
    public List<IZosBatchJobOutputSpoolFile> getSpoolFiles() {
        return this.spoolFiles;
    }

    @Override
    public List<String> toList() {
        ArrayList<String> spoolFilesList = new ArrayList<String>();
        this.spoolFiles.forEach((? super E spoolFile) -> spoolFilesList.add(spoolFile.getRecords()));
        return spoolFilesList;
    }

    public String toString() {
        return this.jobname + "_" + this.jobid;
    }

    @Override
    public Iterator<IZosBatchJobOutputSpoolFile> iterator() {
        final Iterator<IZosBatchJobOutputSpoolFile> spoolFilesIterator = this.spoolFiles.iterator();
        return new Iterator<IZosBatchJobOutputSpoolFile>(){

            @Override
            public boolean hasNext() {
                return spoolFilesIterator.hasNext();
            }

            @Override
            public IZosBatchJobOutputSpoolFile next() {
                return (IZosBatchJobOutputSpoolFile)spoolFilesIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Object cannot be updated");
            }
        };
    }

    @Override
    public int size() {
        return this.spoolFiles.size();
    }

    @Override
    public boolean isEmpty() {
        return this.spoolFiles.isEmpty();
    }
}

