/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosbatch.internal;

import dev.galasa.zosbatch.IZosBatchJob;
import dev.galasa.zosbatch.IZosBatchJobOutputSpoolFile;
import dev.galasa.zosbatch.ZosBatchException;

public class ZosBatchJobOutputSpoolFileImpl
implements IZosBatchJobOutputSpoolFile {
    private IZosBatchJob batchJob;
    private String jobname;
    private String jobid;
    private String stepname;
    private String procstep;
    private String ddname;
    private String id;
    private long size;
    private String records;

    public ZosBatchJobOutputSpoolFileImpl(IZosBatchJob batchJob, String jobname, String jobid, String stepname, String procstep, String ddname, String id, String records) {
        this.batchJob = batchJob;
        this.jobname = jobname;
        this.jobid = jobid;
        this.stepname = stepname;
        this.procstep = procstep;
        this.ddname = ddname;
        this.id = id;
        this.setRecords(records);
    }

    @Override
    public String getJobname() {
        return this.jobname;
    }

    @Override
    public String getJobid() {
        return this.jobid;
    }

    @Override
    public String getStepname() {
        return this.stepname;
    }

    @Override
    public String getProcstep() {
        return this.procstep;
    }

    @Override
    public String getDdname() {
        return this.ddname;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getSize() throws ZosBatchException {
        if (this.records == null) {
            return this.retrieve();
        }
        return this.size;
    }

    @Override
    public String getRecords() {
        return this.records;
    }

    public String toString() {
        return "JOB=" + this.jobname + " JOBID=" + this.jobid + " STEP=" + this.stepname + " PROCSTEP=" + this.procstep + " DDNAME=" + this.ddname;
    }

    @Override
    public void setRecords(String records) {
        this.records = records;
        this.size = this.records != null ? (long)this.records.length() : 0L;
    }

    @Override
    public long retrieve() throws ZosBatchException {
        this.records = this.batchJob.getSpoolFile(this.ddname).getRecords();
        this.size = this.records != null ? (long)this.records.length() : 0L;
        return this.size;
    }

    @Override
    public void saveToResultsArchive(String rasPath) throws ZosBatchException {
        this.batchJob.saveSpoolFileToResultsArchive(this, rasPath);
    }
}

