/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosbatch.internal;

import dev.galasa.zos.IZosImage;
import dev.galasa.zosbatch.IZosBatchJobname;
import dev.galasa.zosbatch.ZosBatchException;
import dev.galasa.zosbatch.ZosBatchManagerException;
import dev.galasa.zosbatch.internal.properties.JobnamePrefix;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.RandomStringUtils;

public class ZosBatchJobnameImpl
implements IZosBatchJobname {
    private String name;
    private String jobNamePrefix;

    public ZosBatchJobnameImpl(@NotNull IZosImage image) throws ZosBatchException {
        try {
            this.jobNamePrefix = JobnamePrefix.get(image.getImageID());
        }
        catch (ZosBatchManagerException e) {
            throw new ZosBatchException("Problem getting batch jobname prefix", (Throwable)((Object)e));
        }
        this.name = this.jobNamePrefix + RandomStringUtils.randomAlphanumeric((int)(8 - this.jobNamePrefix.length())).toUpperCase();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public ZosBatchJobnameImpl(String name) {
        this.name = name.toUpperCase();
    }
}

