/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosbatch.internal.properties;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.cps.CpsProperties;
import dev.galasa.zos.IZosImage;
import dev.galasa.zosbatch.ZosBatchManagerException;
import dev.galasa.zosbatch.internal.properties.ZosBatchPropertiesSingleton;

public class InputClass
extends CpsProperties {
    private static final String DEFAULT_CLASS = "A";

    public static String get(IZosImage image) throws ZosBatchManagerException {
        try {
            String inputClass = InputClass.getStringNulled((IConfigurationPropertyStoreService)ZosBatchPropertiesSingleton.cps(), (String)"default", (String)"input.class", (String[])new String[]{image.getImageID()});
            if (inputClass == null) {
                return DEFAULT_CLASS;
            }
            if ((inputClass = inputClass.toUpperCase()).length() == 0 || inputClass.length() > 8 || !inputClass.matches("^[A-Z0-9]*$")) {
                throw new ZosBatchManagerException("Input class value must be between 1 and 8 characters in the range [A-Z0-9]");
            }
            return inputClass;
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new ZosBatchManagerException("Problem asking the CPS for the zOSMF default input class for zOS image " + image.getImageID(), e);
        }
    }
}

