/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosbatch.internal.properties;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.cps.CpsProperties;
import dev.galasa.zosbatch.ZosBatchManagerException;
import dev.galasa.zosbatch.internal.properties.ZosBatchPropertiesSingleton;

public class JobWaitTimeout
extends CpsProperties {
    private static final int DEFAULT_JOB_WAIT_TIMEOUT = 300;

    public static int get(String imageId) throws ZosBatchManagerException {
        try {
            String timeoutString = JobWaitTimeout.getStringNulled((IConfigurationPropertyStoreService)ZosBatchPropertiesSingleton.cps(), (String)"batchjob", (String)"timeout", (String[])new String[]{imageId});
            if (timeoutString == null) {
                return 300;
            }
            int timeout = Integer.parseInt(timeoutString);
            if (timeout < 0) {
                throw new ZosBatchManagerException("Batch job wait timeout property must be a positive integer");
            }
            return timeout;
        }
        catch (ConfigurationPropertyStoreException | NumberFormatException e) {
            throw new ZosBatchManagerException("Problem asking the CPS for the batch job wait timeout property for zOS image " + imageId, e);
        }
    }
}

