/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosbatch.internal.properties;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.cps.CpsProperties;
import dev.galasa.zosbatch.ZosBatchManagerException;
import dev.galasa.zosbatch.internal.properties.ZosBatchPropertiesSingleton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobnamePrefix
extends CpsProperties {
    private static final Log logger = LogFactory.getLog(JobnamePrefix.class);
    private static final String DEFAULT_JOBNAME_PREFIX = "GAL";

    public static String get(String imageId) throws ZosBatchManagerException {
        try {
            String jobNamePrefixValue = JobnamePrefix.getStringNulled((IConfigurationPropertyStoreService)ZosBatchPropertiesSingleton.cps(), (String)"jobname", (String)"prefix", (String[])new String[]{imageId});
            if (jobNamePrefixValue == null) {
                return DEFAULT_JOBNAME_PREFIX;
            }
            String jobNamePrefix = jobNamePrefixValue.toUpperCase();
            if (jobNamePrefix.length() > 7 || !jobNamePrefix.matches("^[A-Z$#@][A-Z0-9$#@]*$")) {
                logger.warn((Object)("Invalid Batch Job prefix \"" + jobNamePrefixValue + "\". Using default value of \"GAL\""));
                return DEFAULT_JOBNAME_PREFIX;
            }
            return jobNamePrefix;
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new ZosBatchManagerException("Problem asking the CPS for the zOSMF jobname prefix for zOS image " + imageId, e);
        }
    }
}

