/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosbatch.internal.properties;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.cps.CpsProperties;
import dev.galasa.zos.IZosImage;
import dev.galasa.zosbatch.ZosBatchManagerException;
import dev.galasa.zosbatch.internal.properties.ZosBatchPropertiesSingleton;

public class MsgClass
extends CpsProperties {
    private static final String DEFAULT_CLASS = "A";

    public static String get(IZosImage image) throws ZosBatchManagerException {
        try {
            String msgClass = MsgClass.getStringNulled((IConfigurationPropertyStoreService)ZosBatchPropertiesSingleton.cps(), (String)"default", (String)"message.class", (String[])new String[]{image.getImageID()});
            if (msgClass == null) {
                return DEFAULT_CLASS;
            }
            if ((msgClass = msgClass.toUpperCase()).length() != 1 || !msgClass.matches("^[A-Z0-9]*$")) {
                throw new ZosBatchManagerException("Message class value must be 1 character in the range [A-Z0-9]");
            }
            return msgClass;
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new ZosBatchManagerException("Problem asking the CPS for the zOSMF default message class for zOS image " + image.getImageID(), e);
        }
    }
}

