/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosbatch.internal.properties;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.cps.CpsProperties;
import dev.galasa.zos.IZosImage;
import dev.galasa.zosbatch.ZosBatchManagerException;
import dev.galasa.zosbatch.internal.properties.ZosBatchPropertiesSingleton;

public class MsgLevel
extends CpsProperties {
    private static final String DEFAULT_LEVEL = "(1,1)";

    public static String get(IZosImage image) throws ZosBatchManagerException {
        try {
            String messageLevel = MsgLevel.getStringNulled((IConfigurationPropertyStoreService)ZosBatchPropertiesSingleton.cps(), (String)"default", (String)"message.level", (String[])new String[]{image.getImageID()});
            if (messageLevel == null) {
                return DEFAULT_LEVEL;
            }
            if (!messageLevel.matches("[0-3]|(^[\\(]([0-3]?)[,][0-2]?[\\)])")) {
                throw new ZosBatchManagerException("Message level value invalid. Valid examples: \"(2,1)\", \"0\", \"(,0)\"");
            }
            return messageLevel;
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new ZosBatchManagerException("Problem asking the CPS for the zOSMF default message level for zOS image " + image.getImageID(), e);
        }
    }
}

