/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosbatch.internal.properties;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.zosbatch.ZosBatchManagerException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ZosBatchPropertiesSingleton.class}, immediate=true)
public class ZosBatchPropertiesSingleton {
    private static ZosBatchPropertiesSingleton singletonInstance;
    private IConfigurationPropertyStoreService cps;

    private static void setInstance(ZosBatchPropertiesSingleton instance) {
        singletonInstance = instance;
    }

    @Activate
    public void activate() {
        ZosBatchPropertiesSingleton.setInstance(this);
    }

    @Deactivate
    public void deacivate() {
        ZosBatchPropertiesSingleton.setInstance(null);
    }

    public static IConfigurationPropertyStoreService cps() throws ZosBatchManagerException {
        if (singletonInstance != null) {
            return ZosBatchPropertiesSingleton.singletonInstance.cps;
        }
        throw new ZosBatchManagerException("Attempt to access manager CPS before it has been initialised");
    }

    public static void setCps(IConfigurationPropertyStoreService cps) throws ZosBatchManagerException {
        if (singletonInstance != null) {
            ZosBatchPropertiesSingleton.singletonInstance.cps = cps;
            return;
        }
        throw new ZosBatchManagerException("Attempt to set manager CPS before instance created");
    }
}

