/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosconsole.internal.properties;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.zosconsole.ZosConsoleManagerException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ZosConsolePropertiesSingleton.class}, immediate=true)
public class ZosConsolePropertiesSingleton {
    private static ZosConsolePropertiesSingleton singletonInstance;
    private IConfigurationPropertyStoreService cps;

    private static void setInstance(ZosConsolePropertiesSingleton instance) {
        singletonInstance = instance;
    }

    @Activate
    public void activate() {
        ZosConsolePropertiesSingleton.setInstance(this);
    }

    @Deactivate
    public void deacivate() {
        ZosConsolePropertiesSingleton.setInstance(null);
    }

    public static IConfigurationPropertyStoreService cps() throws ZosConsoleManagerException {
        if (singletonInstance != null) {
            return ZosConsolePropertiesSingleton.singletonInstance.cps;
        }
        throw new ZosConsoleManagerException("Attempt to access manager CPS before it has been initialised");
    }

    public static void setCps(IConfigurationPropertyStoreService cps) throws ZosConsoleManagerException {
        if (singletonInstance != null) {
            ZosConsolePropertiesSingleton.singletonInstance.cps = cps;
            return;
        }
        throw new ZosConsoleManagerException("Attempt to set manager CPS before instance created");
    }
}

