/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosfile;

import dev.galasa.zosfile.ZosDatasetException;
import java.util.Collection;
import javax.validation.constraints.NotNull;

public interface IZosDataset {
    public IZosDataset create() throws ZosDatasetException;

    public boolean delete() throws ZosDatasetException;

    public boolean exists() throws ZosDatasetException;

    public void storeText(@NotNull String var1) throws ZosDatasetException;

    public void storeBinary(@NotNull byte[] var1) throws ZosDatasetException;

    public String retrieveAsText() throws ZosDatasetException;

    public byte[] retrieveAsBinary() throws ZosDatasetException;

    public void saveToResultsArchive(String var1) throws ZosDatasetException;

    public boolean isPDS() throws ZosDatasetException;

    public String getMemberName();

    public void memberCreate(@NotNull String var1) throws ZosDatasetException;

    public void memberDelete(@NotNull String var1) throws ZosDatasetException;

    public boolean memberExists(@NotNull String var1) throws ZosDatasetException;

    public void memberStoreText(@NotNull String var1, @NotNull String var2) throws ZosDatasetException;

    public void memberStoreBinary(@NotNull String var1, @NotNull byte[] var2) throws ZosDatasetException;

    public String memberRetrieveAsText(@NotNull String var1) throws ZosDatasetException;

    public byte[] memberRetrieveAsBinary(@NotNull String var1) throws ZosDatasetException;

    public Collection<String> memberList() throws ZosDatasetException;

    public void memberSaveToResultsArchive(@NotNull String var1, String var2) throws ZosDatasetException;

    public void setDataType(DatasetDataType var1);

    public void setVolumes(String var1);

    public void setUnit(String var1);

    public void setDatasetOrganization(DatasetOrganization var1);

    public void setSpace(SpaceUnit var1, int var2, int var3);

    public void setDirectoryBlocks(int var1);

    public void setRecordFormat(RecordFormat var1);

    public void setBlockSize(int var1);

    public void setRecordlength(int var1);

    public void setManagementClass(String var1);

    public void setStorageClass(String var1);

    public void setDataClass(String var1);

    public void setDatasetType(DSType var1);

    public String getName();

    public DatasetDataType getDataType();

    public String getVolumes();

    public String getUnit();

    public DatasetOrganization getDatasetOrganization();

    public SpaceUnit getSpaceUnit();

    public int getPrimaryExtents();

    public int getSecondaryExtents();

    public int getDirectoryBlocks();

    public RecordFormat getRecordFormat();

    public int getBlockSize();

    public int getRecordlength();

    public String getManagementClass();

    public String getStorageClass();

    public String getDataClass();

    public DSType getDatasetType();

    public int getExtents();

    public int getUsed();

    public String getCreateDate();

    public String getReferencedDate();

    public String getExpirationDate();

    public void retrieveAttibutes() throws ZosDatasetException;

    public String getAttibutesAsString() throws ZosDatasetException;

    public void setShouldArchive(boolean var1);

    public boolean shouldArchive();

    public void setShouldCleanup(boolean var1);

    public boolean shouldCleanup();

    public static enum DatasetDataType {
        TEXT("text"),
        BINARY("binary"),
        RECORD("record");

        private String dataType;

        private DatasetDataType(String dataType) {
            this.dataType = dataType;
        }

        public String toString() {
            return this.dataType;
        }

        public static DatasetDataType valueOfLabel(String label) {
            for (DatasetDataType element : DatasetDataType.values()) {
                if (!element.dataType.equals(label)) continue;
                return element;
            }
            return null;
        }
    }

    public static enum SpaceUnit {
        TRACKS("TRK"),
        CYLINDERS("CYL");

        private String unit;

        private SpaceUnit(String spaceUnit) {
            this.unit = spaceUnit;
        }

        public String toString() {
            return this.unit;
        }

        public static SpaceUnit valueOfLabel(String label) {
            for (SpaceUnit element : SpaceUnit.values()) {
                if (!element.unit.equals(label)) continue;
                return element;
            }
            return null;
        }
    }

    public static enum DatasetOrganization {
        PARTITIONED("PO"),
        SEQUENTIAL("PS");

        private String format;

        private DatasetOrganization(String format) {
            this.format = format;
        }

        public String toString() {
            return this.format;
        }

        public static DatasetOrganization valueOfLabel(String label) {
            for (DatasetOrganization element : DatasetOrganization.values()) {
                if (!element.format.equals(label)) continue;
                return element;
            }
            return null;
        }
    }

    public static enum RecordFormat {
        BLOCK("B"),
        FIXED("F"),
        FIXED_BLOCKED("FB"),
        VARIABLE("V"),
        VARIABLE_BLOCKED("VB"),
        UNDEFINED("U");

        private String format;

        private RecordFormat(String format) {
            this.format = format;
        }

        public String toString() {
            return this.format;
        }

        public static RecordFormat valueOfLabel(String label) {
            for (RecordFormat element : RecordFormat.values()) {
                if (!element.format.equals(label)) continue;
                return element;
            }
            return null;
        }
    }

    public static enum DSType {
        HFS("HFS"),
        PDS("PDS"),
        PDSE("PDSE"),
        LIBRARY("LIBRARY"),
        LARGE("LARGE"),
        BASIC("BASIC"),
        EXTREQ("EXTREQ"),
        EXTPREF("EXTPREF");

        private String type;

        private DSType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static DSType valueOfLabel(String label) {
            for (DSType element : DSType.values()) {
                if (!element.type.equals(label)) continue;
                return element;
            }
            return null;
        }
    }
}

