/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosfile;

import dev.galasa.zosfile.ZosUNIXFileException;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.SortedMap;
import javax.validation.constraints.NotNull;

public interface IZosUNIXFile {
    public IZosUNIXFile create() throws ZosUNIXFileException;

    public IZosUNIXFile create(Set<PosixFilePermission> var1) throws ZosUNIXFileException;

    public boolean delete() throws ZosUNIXFileException;

    public boolean directoryDeleteNonEmpty() throws ZosUNIXFileException;

    public boolean exists() throws ZosUNIXFileException;

    public void storeText(String var1) throws ZosUNIXFileException;

    public void storeBinary(@NotNull byte[] var1) throws ZosUNIXFileException;

    public String retrieveAsText() throws ZosUNIXFileException;

    public byte[] retrieveAsBinary() throws ZosUNIXFileException;

    public void saveToResultsArchive(String var1) throws ZosUNIXFileException;

    public boolean isDirectory() throws ZosUNIXFileException;

    public SortedMap<String, IZosUNIXFile> directoryList() throws ZosUNIXFileException;

    public SortedMap<String, IZosUNIXFile> directoryListRecursive() throws ZosUNIXFileException;

    public void setDataType(UNIXFileDataType var1);

    public void setAccessPermissions(Set<PosixFilePermission> var1, boolean var2) throws ZosUNIXFileException;

    public UNIXFileType getFileType();

    public UNIXFileDataType getDataType();

    public String getUnixPath();

    public String getFileName();

    public String getDirectoryPath() throws ZosUNIXFileException;

    public Set<PosixFilePermission> getFilePermissions() throws ZosUNIXFileException;

    public int getSize() throws ZosUNIXFileException;

    public String getLastModified() throws ZosUNIXFileException;

    public String getUser() throws ZosUNIXFileException;

    public String getGroup() throws ZosUNIXFileException;

    public void retrieveAttributes() throws ZosUNIXFileException;

    public String getAttributesAsString() throws ZosUNIXFileException;

    public void setShouldArchive(boolean var1);

    public boolean shouldArchive();

    public void setShouldCleanup(boolean var1);

    public boolean shouldCleanup();

    public static String posixFilePermissionsToSymbolicNotation(Set<PosixFilePermission> accessPermissions) {
        StringBuilder permissions = new StringBuilder();
        permissions.append("---------");
        for (PosixFilePermission posixFilePermission : accessPermissions) {
            switch (posixFilePermission) {
                case OWNER_READ: {
                    permissions.replace(0, 1, "r");
                    break;
                }
                case OWNER_WRITE: {
                    permissions.replace(1, 2, "w");
                    break;
                }
                case OWNER_EXECUTE: {
                    permissions.replace(2, 3, "x");
                    break;
                }
                case GROUP_READ: {
                    permissions.replace(3, 4, "r");
                    break;
                }
                case GROUP_WRITE: {
                    permissions.replace(4, 5, "w");
                    break;
                }
                case GROUP_EXECUTE: {
                    permissions.replace(5, 6, "x");
                    break;
                }
                case OTHERS_READ: {
                    permissions.replace(6, 7, "r");
                    break;
                }
                case OTHERS_WRITE: {
                    permissions.replace(7, 8, "w");
                    break;
                }
                case OTHERS_EXECUTE: {
                    permissions.replace(8, 9, "x");
                    break;
                }
            }
        }
        return permissions.toString();
    }

    public static String posixFilePermissionsToOctal(Set<PosixFilePermission> accessPermissions) {
        int permissions = 0;
        for (PosixFilePermission posixFilePermission : accessPermissions) {
            switch (posixFilePermission) {
                case OWNER_READ: {
                    permissions += 400;
                    break;
                }
                case OWNER_WRITE: {
                    permissions += 200;
                    break;
                }
                case OWNER_EXECUTE: {
                    permissions += 100;
                    break;
                }
                case GROUP_READ: {
                    permissions += 40;
                    break;
                }
                case GROUP_WRITE: {
                    permissions += 20;
                    break;
                }
                case GROUP_EXECUTE: {
                    permissions += 10;
                    break;
                }
                case OTHERS_READ: {
                    permissions += 4;
                    break;
                }
                case OTHERS_WRITE: {
                    permissions += 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    ++permissions;
                    break;
                }
            }
        }
        return String.format("%03d", permissions);
    }

    public static enum UNIXFileDataType {
        TEXT("text"),
        BINARY("binary");

        private String dataType;

        private UNIXFileDataType(String dataType) {
            this.dataType = dataType;
        }

        public String toString() {
            return this.dataType;
        }
    }

    public static enum UNIXFileType {
        FILE("file"),
        CHARACTER("character"),
        DIRECTORY("directory"),
        EXTLINK("extlink"),
        SYMBLINK("symblink"),
        FIFO("FIFO"),
        SOCKET("socket"),
        UNKNOWN("UNKNOWN");

        private String fileType;

        private UNIXFileType(String dataType) {
            this.fileType = dataType;
        }

        public String toString() {
            return this.fileType;
        }
    }
}

