/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosfile.internal.properties;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.cps.CpsProperties;
import dev.galasa.zosfile.ZosFileManagerException;
import dev.galasa.zosfile.internal.properties.ZosFilePropertiesSingleton;

public class DirectoryListMaxItems
extends CpsProperties {
    private static final int MAX_ITEMS = 1000;

    public static int get(String imageId) throws ZosFileManagerException {
        try {
            String maxItemsString = DirectoryListMaxItems.getStringNulled((IConfigurationPropertyStoreService)ZosFilePropertiesSingleton.cps(), (String)"unix", (String)"directory.list.max.items", (String[])new String[]{imageId});
            if (maxItemsString == null) {
                return 1000;
            }
            int maxItems = Integer.parseInt(maxItemsString);
            if (maxItems <= 0) {
                throw new ZosFileManagerException("Directory list max items property must be greater than 0");
            }
            return maxItems;
        }
        catch (ConfigurationPropertyStoreException | NumberFormatException e) {
            throw new ZosFileManagerException("Problem asking the CPS for the directory list max items property for zOS image " + imageId, e);
        }
    }
}

