/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosfile.internal.properties;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.cps.CpsProperties;
import dev.galasa.zosfile.ZosFileManagerException;
import dev.galasa.zosfile.internal.properties.ZosFilePropertiesSingleton;

public class UnixFilePermissions
extends CpsProperties {
    private static final String UNIX_FILE_PERMISSIONS = "rwxrwxr-x";

    public static String get(String imageId) throws ZosFileManagerException {
        try {
            String modeString = UnixFilePermissions.getStringNulled((IConfigurationPropertyStoreService)ZosFilePropertiesSingleton.cps(), (String)"zosfile", (String)"unix.file.permissions", (String[])new String[]{imageId});
            if (modeString == null) {
                return UNIX_FILE_PERMISSIONS;
            }
            if (!modeString.matches("([-r][-w][-x]){3}")) {
                throw new ZosFileManagerException("The default UNIX file permissions property must be in the range \"---------\" to \"rwxrwxrwx\" and match the regex expression \"([-r][-w][-x]){3}\"");
            }
            return modeString;
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new ZosFileManagerException("Problem asking the CPS for the default UNIX file permissions property for zOS image " + imageId, e);
        }
    }
}

