/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosfile.internal.properties;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.zosfile.ZosFileManagerException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ZosFilePropertiesSingleton.class}, immediate=true)
public class ZosFilePropertiesSingleton {
    private static ZosFilePropertiesSingleton singletonInstance;
    private IConfigurationPropertyStoreService cps;

    private static void setInstance(ZosFilePropertiesSingleton instance) {
        singletonInstance = instance;
    }

    @Activate
    public void activate() {
        ZosFilePropertiesSingleton.setInstance(this);
    }

    @Deactivate
    public void deacivate() {
        ZosFilePropertiesSingleton.setInstance(null);
    }

    public static IConfigurationPropertyStoreService cps() throws ZosFileManagerException {
        if (singletonInstance != null) {
            return ZosFilePropertiesSingleton.singletonInstance.cps;
        }
        throw new ZosFileManagerException("Attempt to access manager CPS before it has been initialised");
    }

    public static void setCps(IConfigurationPropertyStoreService cps) throws ZosFileManagerException {
        if (singletonInstance != null) {
            ZosFilePropertiesSingleton.singletonInstance.cps = cps;
            return;
        }
        throw new ZosFileManagerException("Attempt to set manager CPS before instance created");
    }
}

