/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.maven.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;

@Mojo(name="bundletestcat", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class BuildBundleTestCatalog
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> classpathElements;
    @Parameter(defaultValue="${galasa.skip.bundletestcatatlog}", readonly=true, required=false)
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path manifestPath;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Bundle Test Catalog build");
            return;
        }
        if (!"bundle".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping Bundle Test Catalog build, not a bundle project");
            return;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        if (!Files.exists(manifestPath = Paths.get(this.outputDirectory.toURI()).resolve("classes").resolve("META-INF").resolve("MANIFEST.MF"), new LinkOption[0])) {
            throw new MojoExecutionException("Unable to build Test Catalog as the META-INF/MANIFEST.MF file is missing");
        }
        try {
            Manifest manifest = new Manifest(Files.newInputStream(manifestPath, new OpenOption[0]));
            String bundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            if (bundleName == null || bundleName.trim().isEmpty()) {
                throw new MojoExecutionException("Unable to determine the Bundle-SymbolicName in the META-INF/MANIFEST.MF file");
            }
            ArrayList<URL> classpathURLs = new ArrayList<URL>();
            this.getLog().debug((CharSequence)"Classpath elements:-");
            for (String element : this.classpathElements) {
                File file = new File(element);
                classpathURLs.add(file.toURI().toURL());
                this.getLog().debug((CharSequence)("  " + file.toURI().toURL()));
            }
            ClassLoader thisLoad = ((Object)((Object)this)).getClass().getClassLoader();
            URLClassLoader load = new URLClassLoader(classpathURLs.toArray(new URL[classpathURLs.size()]), thisLoad);
            Class annotationTest = ReflectionUtils.forName((String)"dev.galasa.Test", (ClassLoader[])new ClassLoader[]{load});
            Class annotationSharedEnv = ReflectionUtils.forName((String)"dev.galasa.SharedEnvironment", (ClassLoader[])new ClassLoader[]{load});
            Class annotationBuilder = ReflectionUtils.forName((String)"dev.galasa.framework.spi.TestCatalogBuilder", (ClassLoader[])new ClassLoader[]{load});
            Class annotationBuilderInterface = ReflectionUtils.forName((String)"dev.galasa.framework.spi.ITestCatalogBuilder", (ClassLoader[])new ClassLoader[]{load});
            if (annotationTest == null || annotationSharedEnv == null || annotationBuilder == null || annotationBuilderInterface == null) {
                this.getLog().warn((CharSequence)"Ignoring bundle for test catalog processing because the annotations are missing on the classpath");
                this.getLog().warn((CharSequence)("dev.galasa.Test=" + annotationSharedEnv));
                this.getLog().warn((CharSequence)("dev.galasa.SharedEnvironment=" + annotationTest));
                this.getLog().warn((CharSequence)("dev.galasa.framework.spi.TestCatalogBuilder=" + annotationBuilder));
                this.getLog().warn((CharSequence)("dev.galasa.framework.spi.ITestCatalogBuilder=" + annotationBuilderInterface));
                return;
            }
            ConfigurationBuilder configuration = new ConfigurationBuilder();
            configuration.addClassLoaders(new ClassLoader[]{load});
            configuration.addUrls(classpathURLs);
            configuration.addScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()});
            Reflections reflections = new Reflections((Configuration)configuration);
            HashMap catalogTestBuilders = new HashMap();
            HashMap catalogSenvBuilders = new HashMap();
            Set testCatalogBuilderClasses = reflections.getTypesAnnotatedWith(annotationBuilder);
            for (Class klass : testCatalogBuilderClasses) {
                if (!annotationBuilderInterface.isAssignableFrom(klass)) continue;
                try {
                    Object instance = klass.newInstance();
                    catalogTestBuilders.put(instance, klass.getMethod("appendTestCatalog", JsonObject.class, JsonObject.class, Class.class));
                    catalogSenvBuilders.put(instance, klass.getMethod("appendTestCatalogForSharedEnvironment", JsonObject.class, Class.class));
                    this.getLog().debug((CharSequence)("Found test catalog builder class " + klass.getName()));
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Ignoring test catalog builder class " + klass.getName()), (Throwable)e);
                }
            }
            Set sourceTestClasses = reflections.getTypesAnnotatedWith(annotationTest);
            JsonObject jsonRoot = new JsonObject();
            JsonObject jsonClasses = new JsonObject();
            jsonRoot.add("classes", (JsonElement)jsonClasses);
            JsonObject jsonPackages = new JsonObject();
            jsonRoot.add("packages", (JsonElement)jsonPackages);
            JsonObject jsonBundles = new JsonObject();
            jsonRoot.add("bundles", (JsonElement)jsonBundles);
            JsonObject jsonSharedEnv = new JsonObject();
            jsonRoot.add("sharedEnvironments", (JsonElement)jsonSharedEnv);
            JsonObject jsonBundle = new JsonObject();
            jsonBundles.add(bundleName, (JsonElement)jsonBundle);
            JsonObject jsonBundlePackages = new JsonObject();
            jsonBundle.add("packages", (JsonElement)jsonBundlePackages);
            this.getLog().info((CharSequence)"Building the Test Catalog for this bundle:-");
            int testCount = 0;
            for (Class sourceTestClass : sourceTestClasses) {
                ++testCount;
                String fullName = bundleName + "/" + sourceTestClass.getName();
                String testClassName = sourceTestClass.getName();
                String packageName = null;
                packageName = sourceTestClass.getPackage() != null ? sourceTestClass.getPackage().getName() : "default";
                this.getLog().info((CharSequence)("     " + testClassName));
                JsonObject jsonTestClass = new JsonObject();
                jsonTestClass.addProperty("name", testClassName);
                jsonTestClass.addProperty("bundle", bundleName);
                jsonTestClass.addProperty("shortName", sourceTestClass.getSimpleName());
                jsonTestClass.addProperty("package", packageName);
                jsonClasses.add(fullName, (JsonElement)jsonTestClass);
                JsonArray jsonPackage = jsonPackages.getAsJsonArray(packageName);
                if (jsonPackage == null) {
                    jsonPackage = new JsonArray();
                    jsonPackages.add(packageName, (JsonElement)jsonPackage);
                }
                jsonPackage.add(fullName);
                jsonPackage = jsonBundlePackages.getAsJsonArray(packageName);
                if (jsonPackage == null) {
                    jsonPackage = new JsonArray();
                    jsonBundlePackages.add(packageName, (JsonElement)jsonPackage);
                }
                jsonPackage.add(fullName);
                for (Map.Entry builder : catalogTestBuilders.entrySet()) {
                    ((Method)builder.getValue()).invoke(builder.getKey(), jsonRoot, jsonTestClass, sourceTestClass);
                }
            }
            Set sourceSenvClasses = reflections.getTypesAnnotatedWith(annotationSharedEnv);
            int senvCount = 0;
            for (Class sourceSenvClass : sourceSenvClasses) {
                ++senvCount;
                String fullName = bundleName + "/" + sourceSenvClass.getName();
                String senvClassName = sourceSenvClass.getName();
                String packageName = null;
                packageName = sourceSenvClass.getPackage() != null ? sourceSenvClass.getPackage().getName() : "default";
                this.getLog().info((CharSequence)("     " + senvClassName));
                JsonObject jsonSenvClass = new JsonObject();
                jsonSenvClass.addProperty("name", senvClassName);
                jsonSenvClass.addProperty("bundle", bundleName);
                jsonSenvClass.addProperty("shortName", sourceSenvClass.getSimpleName());
                jsonSenvClass.addProperty("package", packageName);
                jsonSharedEnv.add(fullName, (JsonElement)jsonSenvClass);
                for (Map.Entry builder : catalogSenvBuilders.entrySet()) {
                    ((Method)builder.getValue()).invoke(builder.getKey(), jsonSenvClass, sourceSenvClass);
                }
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String testCatlog = gson.toJson((JsonElement)jsonRoot);
            File fileTestCatalog = new File(this.outputDirectory, "testcatalog.json");
            FileUtils.writeStringToFile((File)fileTestCatalog, (String)testCatlog, (String)"utf-8");
            this.projectHelper.attachArtifact(this.project, "json", "testcatalog", fileTestCatalog);
            if (testCount == 0) {
                this.getLog().info((CharSequence)"Test catalog built with no test classes defined");
            } else if (testCount == 1) {
                this.getLog().info((CharSequence)"Test catalog built with 1 test class");
            } else {
                this.getLog().info((CharSequence)("Test catalog built with " + testCount + " test classes"));
            }
            if (senvCount == 0) {
                this.getLog().info((CharSequence)"Test catalog built with no shared environments defined");
            } else if (senvCount == 1) {
                this.getLog().info((CharSequence)"Test catalog built with 1 shared environment");
            } else {
                this.getLog().info((CharSequence)("Test catalog built with " + testCount + " shared environments"));
            }
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Problem processing the test catalog for the bundle", t);
        }
    }
}

