/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.maven.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="gherkintestcat", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class BuildGherkinTestCatalog
extends AbstractMojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${galasa.skip.gherkintestcatatlog}", readonly=true, required=false)
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping Gherkin Test Catalog build");
                return;
            }
            if (!this.outputDirectory.exists()) {
                this.outputDirectory.mkdirs();
            }
            JsonObject jsonRoot = new JsonObject();
            JsonObject jsonFeatures = new JsonObject();
            jsonRoot.add("gherkin", (JsonElement)jsonFeatures);
            ArrayList<Path> featureFiles = new ArrayList<Path>();
            Files.list(this.project.getBasedir().toPath()).forEach(new ConsumeDirectory(featureFiles));
            for (Path feature : featureFiles) {
                String featureName = this.project.getBasedir().toPath().relativize(feature).toString();
                JsonObject featureJson = new JsonObject();
                featureJson.addProperty("name", featureName);
                String fileName = feature.getFileName().toString();
                featureJson.addProperty("shortName", fileName.substring(0, fileName.length() - 8));
                String maven = this.project.getGroupId() + "/" + this.project.getArtifactId() + "/" + this.project.getVersion();
                featureJson.addProperty("maven", maven);
                jsonFeatures.add(featureName, (JsonElement)featureJson);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String testCatalog = gson.toJson((JsonElement)jsonRoot);
            File fileTestCatalog = new File(this.outputDirectory, "testcatalog.json");
            FileUtils.writeStringToFile((File)fileTestCatalog, (String)testCatalog, (String)"utf-8");
            this.projectHelper.attachArtifact(this.project, "json", "testcatalog", fileTestCatalog);
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Problem processing the test catalog for the bundle", t);
        }
    }

    private static class ConsumeDirectory
    implements Consumer<Path> {
        private final List<Path> files;

        public ConsumeDirectory(List<Path> files) {
            this.files = files;
        }

        @Override
        public void accept(Path path) {
            try {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.list(path).forEach(new ConsumeDirectory(this.files));
                } else if (path.toFile().getName().endsWith(".feature")) {
                    this.files.add(path);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

