/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.utils.io.IOUtil;

@Mojo(name="gherkinzip", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class BuildGherkinZip
extends AbstractMojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${galasa.skip.gherkinzip}", readonly=true, required=false)
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping Gherkin Zip build");
                return;
            }
            if (!this.outputDirectory.exists()) {
                this.outputDirectory.mkdirs();
            }
            ArrayList<Path> featureFiles = new ArrayList<Path>();
            Files.list(this.project.getBasedir().toPath()).forEach(new ConsumeDirectory(featureFiles));
            Path zipFile = Paths.get(this.outputDirectory.getPath(), this.project.getArtifactId() + "-" + this.project.getVersion() + ".zip");
            FileOutputStream fos = new FileOutputStream(zipFile.toString());
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (Path feature : featureFiles) {
                this.getLog().info((CharSequence)("Zipping " + feature));
                ZipEntry ze = new ZipEntry(this.project.getBasedir().toPath().relativize(feature).toString());
                zos.putNextEntry(ze);
                FileInputStream fis = new FileInputStream(feature.toString());
                IOUtil.copy((InputStream)fis, (OutputStream)zos);
                zos.closeEntry();
                fis.close();
            }
            zos.close();
            fos.close();
            this.projectHelper.attachArtifact(this.project, "zip", "gherkin", zipFile.toFile());
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Problem processing creating zip for gherkin", t);
        }
    }

    private static class ConsumeDirectory
    implements Consumer<Path> {
        private final List<Path> files;

        public ConsumeDirectory(List<Path> files) {
            this.files = files;
        }

        @Override
        public void accept(Path path) {
            try {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.list(path).forEach(new ConsumeDirectory(this.files));
                } else if (path.toFile().getName().endsWith(".feature")) {
                    this.files.add(path);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

