/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.maven.plugin;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import org.apache.felix.bundlerepository.DataModelHelper;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.DataModelHelperImpl;
import org.apache.felix.bundlerepository.impl.RepositoryImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="obrresources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildOBRResources
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}", property="targerDir", required=true)
    private File projectTargetDirectory;
    @Parameter(defaultValue="${galasa.obr.url.type}", property="obrUrlType", required=false)
    private OBR_URL_TYPE obrUrlType;
    @Parameter(defaultValue="false", property="includeSelf", required=false)
    private boolean includeSelf;
    private Field requirementsField;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.requirementsField = ResourceImpl.class.getDeclaredField("m_reqList");
            this.requirementsField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new MojoExecutionException("Unable to adjust the ResourceImpl class for a workaround a bug in Felix", e);
        }
        this.getLog().info((CharSequence)("BuildOBRResources: Building project " + this.project.getName() + ". includeSelf=" + this.includeSelf));
        if (this.obrUrlType == null) {
            this.obrUrlType = OBR_URL_TYPE.mvn;
        }
        DataModelHelperImpl obrDataModelHelper = new DataModelHelperImpl();
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File repositoryFile = new File(this.outputDirectory, "repository.obr");
        this.project.getArtifact().setFile(repositoryFile);
        if (this.includeSelf) {
            DefaultArtifact selfArtifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "jar", null, this.project.getArtifact().getArtifactHandler());
            this.getLog().info((CharSequence)("BuildOBRResources: Adding artifact " + selfArtifact.getId() + "as a dependency to " + this.project.getName()));
            selfArtifact.setResolved(true);
            selfArtifact.setFile(new File(this.projectTargetDirectory.getAbsolutePath() + "/" + this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar"));
            Set dependencyArtifacts = this.project.getDependencyArtifacts();
            dependencyArtifacts.add(selfArtifact);
            this.project.setDependencyArtifacts(dependencyArtifacts);
        }
        RepositoryImpl newRepository = new RepositoryImpl();
        for (Object dependency : this.project.getDependencyArtifacts()) {
            DefaultArtifact artifact;
            if (!(dependency instanceof DefaultArtifact) || !(artifact = (DefaultArtifact)dependency).isResolved() || !artifact.getScope().equals("compile")) continue;
            if (artifact.getFile().getName().endsWith(".jar")) {
                this.processBundle(artifact, newRepository, (DataModelHelper)obrDataModelHelper);
                continue;
            }
            if (!artifact.getFile().getName().endsWith(".obr")) continue;
            this.processObr((Artifact)artifact, newRepository, (DataModelHelper)obrDataModelHelper);
        }
        if (newRepository.getResources() == null || newRepository.getResources().length == 0) {
            throw new MojoFailureException("No resources have been added to the repository");
        }
        this.getLog().info((CharSequence)("BuildOBRResources: OBR Artifact ID is " + this.project.getArtifact().getId()));
        newRepository.setName(this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
        newRepository.setLastModified(sdf.format(Calendar.getInstance().getTime()));
        try {
            FileWriter fw = new FileWriter(repositoryFile);
            obrDataModelHelper.writeRepository((Repository)newRepository, (Writer)fw);
            fw.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem with writing repository.xml", e);
        }
        if (newRepository.getResources().length == 1) {
            this.getLog().info((CharSequence)("BuildOBRResources: Repository created with " + newRepository.getResources().length + " resource stored in " + repositoryFile.getAbsolutePath()));
        } else {
            this.getLog().info((CharSequence)("BuildOBRResources: Repository created with " + newRepository.getResources().length + " resources stored in " + repositoryFile.getAbsolutePath()));
        }
    }

    private void processObr(Artifact artifact, RepositoryImpl newRepository, DataModelHelper obrDataModelHelper) throws MojoExecutionException {
        try (FileReader fr = new FileReader(artifact.getFile());){
            Repository mergeRepository = obrDataModelHelper.readRepository((Reader)fr);
            for (Resource resource : mergeRepository.getResources()) {
                newRepository.addResource(resource);
                this.getLog().info((CharSequence)("BuildOBRResources: Merged bundle " + resource.getPresentationName() + " - " + resource.getId() + " to repository"));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to read existing OBR", e);
        }
    }

    private void processBundle(DefaultArtifact artifact, RepositoryImpl repository, DataModelHelper obrDataModelHelper) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("BuildOBRResources: Processing artifact " + artifact.getId()));
            ResourceImpl newResource = (ResourceImpl)obrDataModelHelper.createResource(artifact.getFile().toURI().toURL());
            if (newResource == null) {
                throw new MojoExecutionException("Problem with jar file. Not an OSGi bundle?");
            }
            try {
                ArrayList requirements = (ArrayList)this.requirementsField.get(newResource);
                if (requirements != null) {
                    Iterator requirementi = requirements.iterator();
                    while (requirementi.hasNext()) {
                        Requirement requirement = (Requirement)requirementi.next();
                        if (!"ee".equals(requirement.getName())) continue;
                        requirementi.remove();
                        this.getLog().info((CharSequence)("Removed requirement from bundle - " + requirement.toString() + " due to https://issues.apache.org/jira/browse/FELIX-57"));
                    }
                }
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Unable to remove execution environment requirement", t);
            }
            URI name = null;
            switch (this.obrUrlType) {
                case mvn: {
                    name = new URI("mvn:" + artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + artifact.getBaseVersion() + "/" + artifact.getType());
                    break;
                }
                default: {
                    name = artifact.getFile().toURI();
                }
            }
            newResource.put((Object)"uri", (Object)name);
            repository.addResource((Resource)newResource);
            this.getLog().info((CharSequence)("BuildOBRResources: Added bundle " + newResource.getPresentationName() + " - " + newResource.getId() + " to repository"));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to process dependency " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion(), e);
        }
    }

    public static enum OBR_URL_TYPE {
        file,
        mvn;

    }
}

