/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.maven.plugin;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.bundlerepository.DataModelHelper;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.DataModelHelperImpl;
import org.apache.felix.bundlerepository.impl.RepositoryImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="obrembedded", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildObrEmbeddedRepository
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    private Path outputRepositoryDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DataModelHelperImpl obrDataModelHelper = new DataModelHelperImpl();
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        this.outputRepositoryDirectory = Paths.get(this.outputDirectory.toURI());
        RepositoryImpl newRepository = new RepositoryImpl();
        Set artifacts = this.project.getArtifacts();
        HashSet<String> validSymbolicNames = new HashSet<String>();
        for (Artifact artifact : artifacts) {
            if (!artifact.getScope().equals("compile") || !"obr".equals(artifact.getType())) continue;
            this.processObr((DataModelHelper)obrDataModelHelper, artifact, validSymbolicNames);
        }
        for (Artifact artifact : artifacts) {
            if (!artifact.getScope().equals("compile") || "obr".equals(artifact.getType())) continue;
            this.processBundle((DataModelHelper)obrDataModelHelper, newRepository, artifact, validSymbolicNames);
        }
        Path repositoryFile = this.outputRepositoryDirectory.resolve("galasa.obr");
        try (FileWriter fw = new FileWriter(repositoryFile.toFile());){
            obrDataModelHelper.writeRepository((Repository)newRepository, (Writer)fw);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem with writing repository.xml", e);
        }
    }

    private void processBundle(DataModelHelper obrDataModelHelper, RepositoryImpl newRepository, Artifact artifact, HashSet<String> validSymbolicNames) throws MojoExecutionException {
        ResourceImpl newResource;
        try {
            newResource = (ResourceImpl)obrDataModelHelper.createResource(artifact.getFile().toURI().toURL());
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Ignoring artifact " + artifact.toString() + " as not a valid OSGi bundle"));
            return;
        }
        if (newResource == null) {
            this.getLog().warn((CharSequence)("Ignoring artifact " + artifact.toString() + " as not a valid OSGi bundle"));
            return;
        }
        if (!validSymbolicNames.contains(newResource.getSymbolicName())) {
            this.getLog().warn((CharSequence)("Ignoring artifact " + artifact.toString() + " as not on the valid symbolicname list"));
            return;
        }
        try {
            Path artifactFile = Paths.get(artifact.getFile().toURI());
            Path targetFile = this.outputRepositoryDirectory.resolve(artifactFile.getFileName());
            Files.copy(artifactFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
            URI uri = new URI("file:" + targetFile.getFileName());
            newResource.put((Object)"uri", (Object)uri);
            newRepository.addResource((Resource)newResource);
            this.getLog().info((CharSequence)("Added bundle " + newResource.getSymbolicName()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem adding bundle to OBR reposiroty", e);
        }
    }

    private void processObr(DataModelHelper obrDataModelHelper, Artifact artifact, HashSet<String> validSymbolicNames) throws MojoExecutionException {
        try (FileReader fr = new FileReader(artifact.getFile());){
            Repository mergeRepository = obrDataModelHelper.readRepository((Reader)fr);
            for (Resource resource : mergeRepository.getResources()) {
                validSymbolicNames.add(resource.getSymbolicName());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to read existing OBR", e);
        }
    }
}

