/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.maven.plugin;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="deploytestcat", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class DeployTestCatalog
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${galasa.skip.bundletestcatatlog}", readonly=true, required=false)
    private boolean skip;
    @Parameter(defaultValue="${galasa.skip.deploytestcatatlog}", readonly=true, required=false)
    private boolean skipDeploy;
    @Parameter(defaultValue="${galasa.test.stream}", readonly=true, required=false)
    private String testStream;
    @Parameter(defaultValue="${galasa.bootstrap}", readonly=true, required=false)
    private URL bootstrapUrl;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipDeploy) {
            this.getLog().info((CharSequence)"Skipping Deploy Test Catalog");
            return;
        }
        if (this.testStream == null) {
            this.getLog().info((CharSequence)"Skipping Deploy Test Catalog - test stream name is missing");
            return;
        }
        if (this.bootstrapUrl == null) {
            this.getLog().info((CharSequence)"Skipping Deploy Test Catalog - Bootstrap URL is missing");
            return;
        }
        if (!"galasa-obr".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping Bundle Test Catalog deploy, not a galasa-obr project");
            return;
        }
        try {
            String sAuthenticationUrl;
            Artifact artifact = null;
            for (Artifact a : this.project.getAttachedArtifacts()) {
                if (!"testcatalog".equals(a.getClassifier()) || !"json".equals(a.getType())) continue;
                artifact = a;
                break;
            }
            if (artifact == null) {
                this.getLog().info((CharSequence)"Skipping Bundle Test Catalog deploy, no test catalog artifact present");
                return;
            }
            Properties bootstrapProperties = new Properties();
            try {
                URLConnection connection = this.bootstrapUrl.openConnection();
                bootstrapProperties.load(connection.getInputStream());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to load the bootstrap properties", e);
            }
            String sTestcatalogUrl = bootstrapProperties.getProperty("framework.testcatalog.url");
            if (sTestcatalogUrl == null || sTestcatalogUrl.trim().isEmpty()) {
                String sBootstrapUrl = this.bootstrapUrl.toString();
                if (!sBootstrapUrl.endsWith("/bootstrap")) {
                    throw new MojoExecutionException("Unable to calculate the test catalog url, the bootstrap url does not end with /bootstrap, need a framework.testcatalog.url property in the bootstrap");
                }
                sTestcatalogUrl = sBootstrapUrl.substring(0, sBootstrapUrl.length() - 10) + "/testcatalog";
            }
            if ((sAuthenticationUrl = bootstrapProperties.getProperty("framework.authentication.url")) != null) {
                throw new MojoExecutionException("Unable to support Galasa authentication at the moment");
            }
            URL testCatalogUrl = new URL(sTestcatalogUrl + "/" + this.testStream);
            HttpURLConnection conn = (HttpURLConnection)testCatalogUrl.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("PUT");
            conn.addRequestProperty("Content-Type", "application/json");
            conn.addRequestProperty("Accept", "application/json");
            FileUtils.copyFile((File)artifact.getFile(), (OutputStream)conn.getOutputStream());
            int rc = conn.getResponseCode();
            String message = conn.getResponseMessage();
            InputStream is = null;
            is = rc < 400 ? conn.getInputStream() : conn.getErrorStream();
            String response = "";
            if (is != null) {
                response = IOUtils.toString((InputStream)is, (String)"utf-8");
            }
            conn.disconnect();
            if (rc >= 400) {
                this.getLog().error((CharSequence)"Deploy to Test Catalog Store failed:-");
                this.getLog().error((CharSequence)(Integer.toString(rc) + " - " + message));
                if (!response.isEmpty()) {
                    this.getLog().error((CharSequence)response);
                }
                throw new MojoExecutionException("Deploy to Test Catalog Store failed");
            }
            this.getLog().info((CharSequence)("Test Catalog successfully deployed to " + testCatalogUrl.toString()));
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Problem merging the test catalog", t);
        }
    }
}

