/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.maven.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="mergetestcat", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class MergeTestCatalogs
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${galasa.skip.bundletestcatatlog}", readonly=true, required=false)
    private boolean skip;
    @Parameter(defaultValue="${galasa.build.job}", readonly=true, required=false)
    private String buildJob;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Bundle Test Catalog build");
            return;
        }
        if (!"galasa-obr".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping Bundle Test Catalog merge, not a galasa-obr project");
            return;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject jsonRoot = new JsonObject();
            JsonObject jsonClasses = new JsonObject();
            jsonRoot.add("classes", (JsonElement)jsonClasses);
            JsonObject jsonPackages = new JsonObject();
            jsonRoot.add("packages", (JsonElement)jsonPackages);
            JsonObject jsonBundles = new JsonObject();
            jsonRoot.add("bundles", (JsonElement)jsonBundles);
            JsonObject jsonSenv = new JsonObject();
            jsonRoot.add("sharedEnvironments", (JsonElement)jsonSenv);
            JsonObject jsonGherkin = new JsonObject();
            jsonRoot.add("gherkin", (JsonElement)jsonGherkin);
            jsonRoot.addProperty("name", this.project.getName());
            Instant now = Instant.now();
            if (this.buildJob == null || this.buildJob.trim().isEmpty()) {
                this.buildJob = this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " - " + now.toString();
            }
            jsonRoot.addProperty("build", this.buildJob);
            jsonRoot.addProperty("version", this.project.getVersion());
            jsonRoot.addProperty("built", now.toString());
            List dependencies = this.project.getDependencies();
            for (Dependency dependency : dependencies) {
                JsonObject subGherkin;
                JsonObject subSenv;
                JsonObject subBundles;
                JsonObject subPackages;
                if (!"compile".equals(dependency.getScope()) || !"jar".equals(dependency.getType())) continue;
                JsonObject testCatalogRoot = null;
                for (org.apache.maven.artifact.Artifact artifact : this.project.getArtifacts()) {
                    if (!dependency.getGroupId().equals(artifact.getGroupId()) || !dependency.getArtifactId().equals(artifact.getArtifactId()) || !dependency.getType().equals(artifact.getType())) continue;
                    testCatalogRoot = this.getEmbeddedTestCatalog(artifact, gson);
                    break;
                }
                if (testCatalogRoot == null) {
                    DefaultArtifact artifactTestCatalog = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), "testcatalog", "json", dependency.getVersion());
                    ArtifactRequest request = new ArtifactRequest();
                    request.setArtifact((Artifact)artifactTestCatalog);
                    ArtifactResult result = null;
                    try {
                        result = this.repoSystem.resolveArtifact(this.repoSession, request);
                    }
                    catch (Exception e) {
                        this.getLog().warn((CharSequence)e.getMessage());
                    }
                    if (result != null) {
                        this.getLog().info((CharSequence)("Merging bundle test catalog " + result.getArtifact().toString()));
                        String subTestCatalog = FileUtils.readFileToString((File)result.getArtifact().getFile(), (String)"utf-8");
                        testCatalogRoot = (JsonObject)gson.fromJson(subTestCatalog, JsonObject.class);
                    }
                }
                if (testCatalogRoot == null) continue;
                JsonObject subTestClasses = testCatalogRoot.getAsJsonObject("classes");
                if (subTestClasses != null) {
                    for (Object testClassEntry : subTestClasses.entrySet()) {
                        String name = (String)testClassEntry.getKey();
                        JsonElement tc = (JsonElement)testClassEntry.getValue();
                        jsonClasses.add(name, tc);
                    }
                }
                if ((subPackages = testCatalogRoot.getAsJsonObject("packages")) != null) {
                    Object testClassEntry;
                    testClassEntry = subPackages.entrySet().iterator();
                    while (testClassEntry.hasNext()) {
                        Map.Entry packageEntry = (Map.Entry)testClassEntry.next();
                        String name = (String)packageEntry.getKey();
                        JsonArray list = (JsonArray)packageEntry.getValue();
                        JsonArray mergedPackage = jsonPackages.getAsJsonArray(name);
                        if (mergedPackage == null) {
                            mergedPackage = new JsonArray();
                            jsonPackages.add(name, (JsonElement)mergedPackage);
                        }
                        for (int i = 0; i < list.size(); ++i) {
                            String className = list.get(i).getAsString();
                            mergedPackage.add(className);
                        }
                    }
                }
                if ((subBundles = testCatalogRoot.getAsJsonObject("bundles")) != null) {
                    for (Object bundleEntry : subBundles.entrySet()) {
                        String name = (String)bundleEntry.getKey();
                        JsonElement tc = (JsonElement)bundleEntry.getValue();
                        jsonBundles.add(name, tc);
                    }
                }
                if ((subSenv = testCatalogRoot.getAsJsonObject("sharedEnvironments")) != null) {
                    Object bundleEntry;
                    bundleEntry = subSenv.entrySet().iterator();
                    while (bundleEntry.hasNext()) {
                        Map.Entry senvEntry = (Map.Entry)bundleEntry.next();
                        String name = (String)senvEntry.getKey();
                        JsonElement tc = (JsonElement)senvEntry.getValue();
                        jsonSenv.add(name, tc);
                    }
                }
                if ((subGherkin = testCatalogRoot.getAsJsonObject("gherkin")) == null) continue;
                for (Map.Entry gherkinEntry : subGherkin.entrySet()) {
                    String name = (String)gherkinEntry.getKey();
                    JsonElement tc = (JsonElement)gherkinEntry.getValue();
                    jsonGherkin.add(name, tc);
                }
            }
            String testCatlog = gson.toJson((JsonElement)jsonRoot);
            File fileTestCatalog = new File(this.outputDirectory, "testcatalog.json");
            FileUtils.writeStringToFile((File)fileTestCatalog, (String)testCatlog, (String)"utf-8");
            this.projectHelper.attachArtifact(this.project, "json", "testcatalog", fileTestCatalog);
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Problem merging the test catalog", t);
        }
    }

    /*
     * Exception decompiling
     */
    private JsonObject getEmbeddedTestCatalog(org.apache.maven.artifact.Artifact artifact, Gson gson) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

