/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="gitcommithash", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true, requiresProject=true)
public class StoreGitCommitHash
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${env.GIT_COMMIT}", property="gitCommitHash", required=false)
    private String hash;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!("bundle".equals(this.project.getPackaging()) || "jar".equals(this.project.getPackaging()) || "eclipse-plugin".equals(this.project.getPackaging()))) {
            return;
        }
        List resources = this.project.getResources();
        if (this.hash == null || this.hash.trim().isEmpty()) {
            this.hash = "unknown";
        }
        this.hash = this.hash.trim();
        File galasaFile = new File(this.outputDirectory, "galasa");
        File metaInf = new File(galasaFile, "META-INF");
        File hashFile = new File(metaInf, "git.hash");
        if (!metaInf.exists()) {
            metaInf.mkdirs();
        }
        try {
            FileUtils.write((File)hashFile, (CharSequence)this.hash, (String)"UTF-8");
            this.getLog().info((CharSequence)("Written git hash " + this.hash + " to META-INF/git.hash"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write hash", (Exception)e);
        }
        Resource resource = new Resource();
        resource.setDirectory(galasaFile.getAbsolutePath());
        this.project.addResource(resource);
    }
}

