/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.fixtures.file;

import com.google.common.base.Preconditions;
import java.io.File;

public class FilePreconditions {
    public static File checkIsDirectory(File file, String message) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (String)"%s because the specified directory is null.", (Object)message);
        Preconditions.checkArgument((boolean)file.exists(), (String)"%s because '%s' does not exists.", (Object)message, (Object)file.getAbsolutePath());
        Preconditions.checkArgument((!file.isFile() ? 1 : 0) != 0, (String)"%s because '%s' is a file.", (Object)message, (Object)file.getAbsolutePath());
        Preconditions.checkArgument((boolean)file.isDirectory(), (String)"%s because '%s' is not a directory.", (Object)message, (Object)file.getAbsolutePath());
        return file;
    }

    public static File checkNotExistingFile(File file, String message) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (String)"%s because the specified file is null.", (Object)message);
        Preconditions.checkArgument((!file.exists() || !file.isDirectory() ? 1 : 0) != 0, (String)"%s because '%s' is a directory.", (Object)message, (Object)file.getAbsolutePath());
        return file;
    }

    public static File checkNotExistingDirectory(File file, String message) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (String)"%s because the specified directory is null.", (Object)message);
        Preconditions.checkArgument((!file.exists() || !file.isFile() ? 1 : 0) != 0, (String)"%s because '%s' is a file.", (Object)message, (Object)file.getAbsolutePath());
        return file;
    }

    public static File checkIsNotNull(File file, String message) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (String)"%s because the specified file is null.", (Object)message);
        return file;
    }
}

