/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.archive;

import dev.gradleplugins.test.fixtures.archive.ArchiveTestFixture;
import dev.gradleplugins.test.fixtures.file.TestFile;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

class TarTestFixture
extends ArchiveTestFixture {
    private final TestFile tarFile;

    public TarTestFixture(TestFile tarFile) {
        this(tarFile, null);
    }

    public TarTestFixture(TestFile tarFile, String metadataCharset) {
        this(tarFile, metadataCharset, Charset.defaultCharset().name());
    }

    public TarTestFixture(TestFile tarFile, String metadataCharset, String contentCharset) {
        this.tarFile = tarFile;
        boolean gzip = !tarFile.getName().endsWith("tar");
        try (FileInputStream inputStream = new FileInputStream(tarFile);){
            TarInputStream tarInputStream = new TarInputStream(gzip ? new GZIPInputStream(inputStream) : inputStream, metadataCharset);
            TarEntry tarEntry = tarInputStream.getNextEntry();
            while (tarEntry != null) {
                this.addMode(tarEntry.getName(), tarEntry.getMode());
                if (!tarEntry.isDirectory()) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    tarInputStream.copyEntryContents((OutputStream)stream);
                    this.add(tarEntry.getName(), new String(stream.toByteArray(), contentCharset));
                }
                tarEntry = tarInputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

