/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.integtests.fixtures;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dev.gradleplugins.integtests.fixtures.AbstractMultiVersionSpecRunner;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractContextualMultiVersionSpecRunner<T extends AbstractMultiVersionSpecRunner.VersionedTool>
extends AbstractMultiVersionSpecRunner<T> {
    public static final String VERSIONS_SYSPROP_NAME = "org.gradle.integtest.versions";
    public static final AbstractMultiVersionSpecRunner.CoverageContext DEFAULT = new AbstractMultiVersionSpecRunner.CoverageContext("default");
    public static final AbstractMultiVersionSpecRunner.CoverageContext LATEST = new AbstractMultiVersionSpecRunner.CoverageContext("latest");
    public static final AbstractMultiVersionSpecRunner.CoverageContext PARTIAL = new AbstractMultiVersionSpecRunner.CoverageContext("partial");
    public static final AbstractMultiVersionSpecRunner.CoverageContext FULL = new AbstractMultiVersionSpecRunner.CoverageContext("all");

    @Override
    protected String getVersions() {
        return System.getProperty(VERSIONS_SYSPROP_NAME, DEFAULT.getSelector());
    }

    @Override
    protected abstract Collection<T> getAllVersions();

    protected Collection<T> getLatestVersion() {
        return Collections.singleton(Iterables.getLast(this.getAllVersions()));
    }

    protected Collection<T> getQuickVersions() {
        for (AbstractMultiVersionSpecRunner.VersionedTool next : this.getAllVersions()) {
            if (!this.isAvailable(next)) continue;
            return Collections.singleton(next);
        }
        return Collections.emptyList();
    }

    protected Collection<T> getPartialVersions() {
        T lastAvailable;
        Collection<T> allVersions = this.getAllVersions();
        HashSet<T> partialVersions = new HashSet<T>();
        T firstAvailable = this.getFirstAvailable(allVersions);
        if (firstAvailable != null) {
            partialVersions.add(firstAvailable);
        }
        if ((lastAvailable = this.getLastAvailable(allVersions)) != null) {
            partialVersions.add(lastAvailable);
        }
        return partialVersions;
    }

    private Collection<T> getAvailableVersions() {
        Set allAvailable = this.getAllVersions().stream().filter(this::isAvailable).collect(Collectors.toSet());
        return allAvailable;
    }

    private T getFirstAvailable(Collection<T> versions) {
        for (AbstractMultiVersionSpecRunner.VersionedTool next : versions) {
            if (!this.isAvailable(next)) continue;
            return (T)next;
        }
        return null;
    }

    private T getLastAvailable(Collection<T> versions) {
        AbstractMultiVersionSpecRunner.VersionedTool lastAvailable = null;
        for (AbstractMultiVersionSpecRunner.VersionedTool next : versions) {
            if (!this.isAvailable(next)) continue;
            lastAvailable = next;
        }
        return (T)lastAvailable;
    }

    public AbstractContextualMultiVersionSpecRunner(Class<?> target) {
        super(target, (Set<AbstractMultiVersionSpecRunner.CoverageContext>)ImmutableSet.of((Object)DEFAULT, (Object)LATEST, (Object)PARTIAL, (Object)FULL));
    }

    @Override
    protected Collection<T> versionUnderTestForContext(AbstractMultiVersionSpecRunner.CoverageContext coverageContext) {
        if (coverageContext == DEFAULT) {
            return this.getQuickVersions();
        }
        if (coverageContext == LATEST) {
            return this.getLatestVersion();
        }
        if (coverageContext == PARTIAL) {
            return this.getPartialVersions();
        }
        if (coverageContext == FULL) {
            return this.getAvailableVersions();
        }
        throw new IllegalArgumentException();
    }
}

