/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.spock.lang;

import dev.gradleplugins.spock.lang.CleanupTestDirectory;
import dev.gradleplugins.spock.lang.TestDirectoryProvider;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.extension.AbstractAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.SpecInfo;

public class CleanupTestDirectoryExtension
extends AbstractAnnotationDrivenExtension<CleanupTestDirectory> {
    public void visitSpecAnnotation(CleanupTestDirectory annotation, SpecInfo spec) {
        spec.getFeatures().forEach(feature -> feature.addIterationInterceptor((IMethodInterceptor)new FailureCleanupInterceptor(annotation.fieldName())));
    }

    private static class FailureCleanupInterceptor
    implements IMethodInterceptor {
        final String fieldName;

        FailureCleanupInterceptor(String fieldName) {
            this.fieldName = fieldName;
        }

        public void intercept(final IMethodInvocation invocation) throws Throwable {
            AbstractRunListener noCleanupOnErrorListener = new AbstractRunListener(){

                public void error(ErrorInfo error) {
                    TestDirectoryProvider provider = (TestDirectoryProvider)GroovyRuntimeUtil.getProperty((Object)invocation.getInstance(), (String)fieldName);
                    provider.suppressCleanup();
                }
            };
            for (SpecInfo spec = invocation.getSpec(); spec != null; spec = spec.getSubSpec()) {
                spec.addListener((IRunListener)noCleanupOnErrorListener);
            }
            invocation.proceed();
        }
    }
}

