/*
 * Decompiled with CFR 0.152.
 */
package ball.activation;

import ball.activation.AbstractDataSource;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;

public class ByteArrayDataSource
extends AbstractDataSource {
    private final ByteArrayOutputStreamImpl out = new ByteArrayOutputStreamImpl();

    @ConstructorProperties(value={"name", "contentType"})
    public ByteArrayDataSource(String name, String type) {
        this.setName(name);
        if (type != null) {
            this.setContentType(type);
        }
    }

    @Override
    public void clear() {
        this.out.reset();
    }

    @Override
    public long length() {
        return this.out.size();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.out.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.out.reset();
        return this.out;
    }

    @Override
    @Generated
    public String toString() {
        return "ByteArrayDataSource(out=" + this.out + ")";
    }

    private class ByteArrayOutputStreamImpl
    extends ByteArrayOutputStream {
        public ByteArrayOutputStreamImpl() {
            super(8192);
        }

        public ByteArrayInputStream getInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

