/*
 * Decompiled with CFR 0.152.
 */
package ball.activation;

import ball.activation.AbstractDataSource;
import ball.activation.ByteArrayDataSource;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.activation.DataSource;

public abstract class FilterDataSource
extends AbstractDataSource {
    private final DataSource ds;

    @ConstructorProperties(value={"dataSource"})
    protected FilterDataSource(DataSource ds) {
        this.ds = Objects.requireNonNull(ds);
    }

    private FilterDataSource() {
        this(new ByteArrayDataSource(null, null));
    }

    protected DataSource getDataSource() {
        return this.ds;
    }

    @Override
    public String getName() {
        return this.getDataSource().getName();
    }

    @Override
    public void setName(String name) {
        try {
            DataSource ds = this.getDataSource();
            ds.getClass().getMethod("setName", String.class).invoke((Object)ds, name);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    @Override
    public String getContentType() {
        return this.getDataSource().getContentType();
    }

    @Override
    public void setContentType(String type) {
        try {
            DataSource ds = this.getDataSource();
            ds.getClass().getMethod("setContentType", String.class).invoke((Object)ds, type);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getDataSource().getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getDataSource().getOutputStream();
    }
}

