/*
 * Decompiled with CFR 0.152.
 */
package ball.activation;

import ball.activation.ByteArrayDataSource;
import ball.activation.FilterDataSource;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public class ReaderWriterDataSource
extends FilterDataSource {
    protected static final Charset CHARSET = StandardCharsets.UTF_8;
    private final Charset charset;

    @ConstructorProperties(value={"name", "contentType"})
    public ReaderWriterDataSource(String name, String type) {
        this(name, type, null);
    }

    @ConstructorProperties(value={"name", "contentType", "charset"})
    public ReaderWriterDataSource(String name, String type, Charset charset) {
        this(name, type, charset, null);
    }

    @ConstructorProperties(value={"name", "contentType", "charset", ""})
    public ReaderWriterDataSource(String name, String type, Charset charset, String content) {
        super(new ByteArrayDataSource(name, type));
        Charset charset2 = this.charset = charset != null ? charset : CHARSET;
        if (content != null) {
            try (Writer writer = this.getWriter();){
                writer.write(content);
            }
            catch (IOException exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }
    }

    private ReaderWriterDataSource() {
        this(null, null);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream(), this.getCharset());
    }

    public Writer getWriter() throws IOException {
        return new OutputStreamWriter(this.getOutputStream(), this.getCharset());
    }

    public BufferedReader getBufferedReader() throws IOException {
        return new BufferedReader(this.getReader());
    }

    public PrintWriter getPrintWriter() throws IOException {
        return new PrintWriter(this.getWriter(), true);
    }

    public PrintStream getPrintStream() throws IOException {
        return new PrintStream(this.getOutputStream(), true, this.getCharset().name());
    }

    public void writeTo(PrintWriter writer) throws IOException {
        this.getBufferedReader().lines().forEach(t -> writer.println((String)t));
    }

    @Override
    public String toString() {
        String string = null;
        try (BufferedReader reader = this.getBufferedReader();){
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException exception) {
            string = super.toString();
        }
        return string;
    }

    protected static String nameOf(Charset charset) {
        return charset != null ? charset.name() : null;
    }
}

